/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag;

import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.util.SizeTracker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringData
extends BaseData {
    public static final String TAG_NAME = "TAG_String";
    public final String value;

    public StringData(String value) {
        super(8, TAG_NAME);
        this.value = value;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public StringData copy() {
        return this;
    }

    @Override
    public String toString() {
        return StringData.quoteAndEscape(this.value);
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.value);
    }

    public static StringData read(DataInput input, int depth, SizeTracker sizeTracker) throws IOException {
        String str = input.readUTF();
        sizeTracker.increment(str.length() + 2);
        return new StringData(str);
    }

    public static String quoteAndEscape(String str) {
        StringBuilder sb = new StringBuilder("\"");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.append('\"').toString();
    }
}

