/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag;

import fi.dy.masa.malilib.util.data.tag.ByteArrayData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.EmptyData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntArrayData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.LongArrayData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.StringData;
import fi.dy.masa.malilib.util.data.tag.util.SizeTracker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;

public abstract class BaseData {
    protected final int type;
    protected final String displayName;

    protected BaseData(int type, String displayName) {
        this.type = type;
        this.displayName = displayName;
    }

    public int getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract BaseData copy();

    public abstract String toString();

    public abstract boolean isEmpty();

    public Optional<Number> asNumber() {
        return Optional.empty();
    }

    public abstract void write(DataOutput var1) throws IOException;

    public static BaseData createTag(int tagType, DataInput input, int depth, SizeTracker sizeTracker) throws IOException {
        return switch (tagType) {
            case 1 -> ByteData.read(input, depth, sizeTracker);
            case 2 -> ShortData.read(input, depth, sizeTracker);
            case 3 -> IntData.read(input, depth, sizeTracker);
            case 4 -> LongData.read(input, depth, sizeTracker);
            case 5 -> FloatData.read(input, depth, sizeTracker);
            case 6 -> DoubleData.read(input, depth, sizeTracker);
            case 8 -> StringData.read(input, depth, sizeTracker);
            case 7 -> ByteArrayData.read(input, depth, sizeTracker);
            case 11 -> IntArrayData.read(input, depth, sizeTracker);
            case 12 -> LongArrayData.read(input, depth, sizeTracker);
            case 10 -> CompoundData.read(input, depth, sizeTracker);
            case 9 -> ListData.read(input, depth, sizeTracker);
            case 0 -> EmptyData.read(input, depth, sizeTracker);
            default -> throw new IOException("Unknown tag type " + tagType);
        };
    }
}

