/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.interfaces.IInventoryOverlayHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractNautilus;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.InventoryOverlayContext;
import fi.dy.masa.malilib.render.InventoryOverlayRefresher;
import fi.dy.masa.malilib.test.TestDataSyncer;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.game.RayTraceUtils;
import net.minecraft.class_12116;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2611;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6067;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TestInventoryOverlayHandler
implements IInventoryOverlayHandler {
    private static final TestInventoryOverlayHandler INSTANCE = new TestInventoryOverlayHandler();
    IDataSyncer syncer = null;
    InventoryOverlayContext context = null;
    InventoryOverlayRefresher refresher = null;

    public static TestInventoryOverlayHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getModId() {
        return "malilib";
    }

    @Override
    public IDataSyncer getDataSyncer() {
        if (this.syncer == null) {
            this.syncer = TestDataSyncer.getInstance();
        }
        return this.syncer;
    }

    @Override
    public void setDataSyncer(IDataSyncer syncer) {
        this.syncer = syncer;
    }

    @Override
    public InventoryOverlayRefresher getRefreshHandler() {
        if (this.refresher == null) {
            this.refresher = new Refresher();
        }
        return this.refresher;
    }

    @Override
    public boolean isEmpty() {
        return this.context == null;
    }

    @Override
    @Nullable
    public InventoryOverlayContext getRenderContextNullable() {
        return this.context;
    }

    @Override
    @Nullable
    public InventoryOverlayContext getRenderContext(GuiContext ctx, class_3695 profiler) {
        profiler.method_15396(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventory(ctx.mc());
        if (!this.isEmpty()) {
            this.renderInventoryOverlay(ctx, this.getRenderContextNullable(), true, true);
        }
        profiler.method_15407();
        return this.getRenderContextNullable();
    }

    @Override
    @Nullable
    public InventoryOverlayContext getTargetInventory(class_310 mc) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld(mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.field_1724 == null || world == null || mc.field_1687 == null) {
            return null;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        class_239 trace = cameraEntity != mc.field_1724 ? RayTraceUtils.getRayTraceFromEntity((class_1937)mc.field_1687, cameraEntity, class_3959.class_242.field_1348) : mc.field_1765;
        CompoundData data = new CompoundData();
        if (trace == null || trace.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 blockTmp = state.method_26204();
            class_2586 be = null;
            MaLiLib.LOGGER.warn("getTarget():1: pos [{}], state [{}]", (Object)pos.method_23854(), (Object)state.toString());
            if (blockTmp instanceof class_2343) {
                if (world instanceof class_3218) {
                    be = world.method_8500(pos).method_8321(pos);
                    if (be != null) {
                        data = DataConverterNbt.fromVanillaCompound(be.method_38242((class_7225.class_7874)world.method_30349()));
                    }
                } else {
                    Pair<class_2586, CompoundData> pair = this.getDataSyncer().requestBlockEntity(world, pos);
                    if (pair != null) {
                        data = (CompoundData)pair.getRight();
                    }
                }
                MaLiLib.LOGGER.warn("getTarget():2: pos [{}], be [{}], data [{}]", (Object)pos.method_23854(), (Object)(be != null ? 1 : 0), (Object)(data != null ? 1 : 0));
                return this.getTargetInventoryFromBlock(world, pos, be, data);
            }
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)trace).method_17782();
            if (entity.method_5667().equals(cameraEntity.method_5667())) {
                return null;
            }
            if (mc.field_1692 != null && entity.method_5628() != mc.field_1692.method_5628()) {
                MaLiLib.LOGGER.error("getTarget(): entityId Not Equal: [{} != {}]", (Object)entity.method_5628(), (Object)mc.field_1692.method_5628());
            }
            MaLiLib.LOGGER.warn("getTarget(): entityUUID [{}] vs targetedUUID [{}]", (Object)entity.method_5845(), (Object)(mc.field_1692 != null ? mc.field_1692.method_5845() : "<NULL>"));
            if (world instanceof class_3218) {
                if ((entity = world.method_8469(entity.method_5628())) != null) {
                    return this.getTargetInventoryFromEntity(entity, DataEntityUtils.invokeEntityDataTagNoPassengers(entity, entity.method_5628()));
                }
            } else {
                Pair<class_1297, CompoundData> pair = this.getDataSyncer().requestEntity(world, entity.method_5628());
                if (pair != null) {
                    return this.getTargetInventoryFromEntity(world.method_8469(((class_1297)pair.getLeft()).method_5628()), (CompoundData)pair.getRight());
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public InventoryOverlayContext getTargetInventoryFromBlock(class_1937 world, class_2338 pos, @Nullable class_2586 be, CompoundData data) {
        class_1657 player;
        class_2591<?> beType;
        class_1263 inv;
        if (be != null) {
            if (data.isEmpty()) {
                data = DataConverterNbt.fromVanillaCompound(be.method_38242((class_7225.class_7874)world.method_30349()));
            }
            inv = InventoryUtils.getInventory(world, pos);
        } else {
            Pair<class_2586, CompoundData> pair;
            if (data.isEmpty() && (pair = this.getDataSyncer().requestBlockEntity(world, pos)) != null) {
                data = (CompoundData)pair.getRight();
            }
            inv = this.getDataSyncer().getBlockInventory(world, pos, false);
        }
        MaLiLib.LOGGER.error("getTargetFromBlock: inv [{}], data [{}]", inv != null ? Integer.valueOf(inv.method_5439()) : "<NULL>", (Object)(data != null ? data.toString() : "<NULL>"));
        class_2591<?> class_25912 = beType = data != null ? DataBlockUtils.getBlockEntityType(data) : null;
        if ((beType != null && beType.equals((Object)class_2591.field_11901) || be instanceof class_2611) && class_310.method_1551().field_1724 != null && (player = world.method_18470(class_310.method_1551().field_1724.method_5667())) != null) {
            Pair<class_1297, CompoundData> enderPair = this.getDataSyncer().requestEntity(world, player.method_5628());
            class_1730 enderItems = null;
            if (enderPair != null && enderPair.getRight() != null && ((CompoundData)enderPair.getRight()).contains("EnderItems", 9)) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromData((CompoundData)enderPair.getRight(), world.method_30349());
            } else if (world instanceof class_3218) {
                enderItems = player.method_7274();
            }
            if (enderItems != null) {
                inv = enderItems;
            }
        }
        if (data != null && !data.isEmpty()) {
            class_1263 inv2 = InventoryUtils.getDataInventory(data, inv != null ? inv.method_5439() : -1, world.method_30349());
            if (inv == null) {
                inv = inv2;
            }
        }
        MaLiLib.LOGGER.warn("getTargetFromBlock():3: pos [{}], inv [{}], be [{}], data [{}]", (Object)pos.method_23854(), (Object)(inv != null ? 1 : 0), (Object)(be != null ? 1 : 0), data != null ? data.getString("id") : new CompoundData());
        if (inv == null || data == null) {
            return null;
        }
        this.context = new InventoryOverlayContext(InventoryOverlay.getBestInventoryType(inv, data), inv, be != null ? be : world.method_8321(pos), null, data, this.getRefreshHandler());
        return this.context;
    }

    @Override
    @Nullable
    public InventoryOverlayContext getTargetInventoryFromEntity(class_1297 entity, CompoundData data) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().method_67533().toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof class_12116) {
            inv = ((IMixinAbstractNautilus)entity).malilib_getNautilusInventory();
        } else if (entity instanceof class_6067) {
            inv = ((class_6067)entity).method_35199();
        }
        if (!data.isEmpty()) {
            class_1263 inv2;
            if (inv != null && data.contains("Items", 9) && data.getList("Items").size() > 1) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for horse inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = entity instanceof class_1496 || entity instanceof class_12116 ? InventoryUtils.getDataInventoryHorseFix(data, inv.method_5439(), entity.method_56673()) : InventoryUtils.getDataInventory(data, inv.method_5439(), entity.method_56673());
                inv = null;
            } else if (inv != null && data.containsLenient("equipment") && data.containsLenient("EatingHaystack")) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for saddled horse inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = InventoryUtils.getDataInventoryHorseFix(data, inv.method_5439(), entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 8 && data.contains("Inventory", 9) && !data.getList("Inventory").isEmpty()) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for empty villager/piglin inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = InventoryUtils.getDataInventory(data, 8, entity.method_56673());
                inv = null;
            } else {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Default] inv.size: [{}]", (Object)(inv != null ? inv.method_5439() : -1));
                inv2 = InventoryUtils.getDataInventory(data, inv != null ? inv.method_5439() : -1, entity.method_56673());
                if (inv2 != null) {
                    inv = null;
                }
            }
            MaLiLib.LOGGER.error("getTargetInventoryFromEntity(): inv.size [{}], inv2.size [{}]", inv != null ? Integer.valueOf(inv.method_5439()) : "null", inv2 != null ? Integer.valueOf(inv2.method_5439()) : "null");
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.context = new InventoryOverlayContext(inv != null ? InventoryOverlay.getBestInventoryType(inv, data) : InventoryOverlay.getInventoryType(data), inv, null, entityLivingBase, data, this.getRefreshHandler());
        return this.context;
    }

    public static class Refresher
    implements InventoryOverlayRefresher {
        @Override
        public InventoryOverlayContext onContextRefresh(InventoryOverlayContext data, class_1937 world) {
            if (data.be() != null) {
                TestInventoryOverlayHandler.getInstance().requestBlockEntityAt(world, data.be().method_11016());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromBlock(data.be().method_10997(), data.be().method_11016(), data.be(), data.data());
            } else if (data.entity() != null) {
                TestInventoryOverlayHandler.getInstance().getDataSyncer().requestEntity(world, data.entity().method_5628());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromEntity((class_1297)data.entity(), data.data());
            }
            return data;
        }
    }
}

