/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render.uniform;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.compat.iris.IrisCompat;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import net.minecraft.class_11285;
import net.minecraft.class_12393;
import net.minecraft.class_310;

public class ChunkFixUniform
implements AutoCloseable {
    private static final int UBO_SIZE = new Std140SizeCalculator().putIVec2().putFloat().putInt().putInt().get();
    private final class_11285 ubo = new class_11285(() -> "ChunkFix UBO", 130, UBO_SIZE);

    public void fillBuffer(int atlasWidth, int atlasHeight, float chunkVisibility) throws IllegalArgumentException {
        if (atlasWidth <= 0 || atlasHeight <= 0) {
            throw new IllegalArgumentException("atlasWidth and atlasHeight must be positive");
        }
        int useRGSS = class_310.method_1551().field_1690.method_76747().method_41753() == class_12393.field_64664 ? 1 : 0;
        int hasShadersOn = IrisCompat.isShaderActive() ? 1 : 0;
        try (GpuBuffer.MappedView mappedView = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.ubo.method_71119(), false, true);){
            Std140Builder.intoBuffer((ByteBuffer)mappedView.data()).putIVec2(atlasWidth, atlasHeight).putFloat(chunkVisibility).putInt(useRGSS).putInt(hasShadersOn);
        }
    }

    public void drawPass(@Nonnull RenderPass pass) {
        pass.setUniform("ChunkFix", this.getCurrentBuffer());
    }

    public GpuBuffer getCurrentBuffer() {
        return this.ubo.method_71119();
    }

    public void endFrame() {
        this.ubo.method_71121();
    }

    @Override
    public void close() throws Exception {
        this.ubo.close();
    }
}

