/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.Objects;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_327;

public abstract class WidgetBase {
    protected final class_310 mc;
    protected final class_327 textRenderer;
    protected final int fontHeight;
    protected GuiContext guiContext;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int zLevel;

    public WidgetBase(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.mc = class_310.method_1551();
        this.textRenderer = this.mc.field_1772;
        Objects.requireNonNull(this.textRenderer);
        this.fontHeight = 9;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZLevel(int zLevel) {
        this.zLevel = zLevel;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
    }

    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        if (this.isMouseOver((int)click.comp_4798(), (int)click.comp_4799())) {
            return this.onMouseClickedImpl(click, doubleClick);
        }
        return false;
    }

    protected boolean onMouseClickedImpl(class_11909 click, boolean doubleClick) {
        return false;
    }

    public void onMouseReleased(class_11909 click) {
        this.onMouseReleasedImpl(click);
    }

    public void onMouseReleasedImpl(class_11909 click) {
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.isMouseOver((int)mouseX, (int)mouseY)) {
            return this.onMouseScrolledImpl(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    public boolean onMouseScrolledImpl(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return false;
    }

    public boolean onKeyTyped(class_11908 input) {
        return this.onKeyTypedImpl(input);
    }

    protected boolean onKeyTypedImpl(class_11908 input) {
        return false;
    }

    public boolean onCharTyped(class_11905 input) {
        return this.onCharTypedImpl(input);
    }

    protected boolean onCharTypedImpl(class_11905 input) {
        return false;
    }

    public boolean canSelectAt(class_11909 click) {
        return this.isMouseOver((int)click.comp_4798(), (int)click.comp_4799());
    }

    public int getStringWidth(String text) {
        return this.textRenderer.method_1727(text);
    }

    public void drawString(GuiContext ctx, int x, int y, int color, String text) {
        ctx.method_51433(this.textRenderer, text, x, y, color, false);
    }

    public void drawCenteredString(GuiContext ctx, int x, int y, int color, String text) {
        ctx.method_51433(this.textRenderer, text, x - this.getStringWidth(text) / 2, y, color, false);
    }

    public void drawStringWithShadow(GuiContext ctx, int x, int y, int color, String text) {
        ctx.method_25303(this.textRenderer, text, x, y, color);
    }

    public void drawCenteredStringWithShadow(GuiContext ctx, int x, int y, int color, String text) {
        ctx.method_25300(this.textRenderer, text, x, y, color);
    }

    public void drawBackgroundMask(GuiContext ctx) {
        RenderUtils.drawTexturedRect(ctx, GuiBase.BG_TEXTURE, this.x + 1, this.y + 1, 0, 0, this.width - 2, this.height - 2);
    }

    public void render(GuiContext ctx, int mouseX, int mouseY, boolean selected) {
        if (this.guiContext == null || !((Object)((Object)this.guiContext)).equals((Object)ctx)) {
            this.guiContext = ctx;
        }
    }

    public void postRenderHovered(GuiContext ctx, int mouseX, int mouseY, boolean selected) {
        if (this.guiContext == null || !((Object)((Object)this.guiContext)).equals((Object)ctx)) {
            this.guiContext = ctx;
        }
    }
}

