/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.config.registry;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.data.ModInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ConfigScreenRegistry {
    protected final Map<String, ModInfo> modsMap = new HashMap<String, ModInfo>();
    protected ImmutableList<ModInfo> mods = ImmutableList.of();

    public void registerConfigScreenFactory(ModInfo modInfo) {
        this.modsMap.put(modInfo.modId(), modInfo);
        ArrayList<ModInfo> list = new ArrayList<ModInfo>(this.modsMap.values());
        list.sort(Comparator.comparing(ModInfo::modName));
        this.mods = ImmutableList.copyOf(list);
    }

    @Nullable
    public Supplier<GuiBase> getConfigScreenFactoryFor(ModInfo modInfo) {
        return this.modsMap.get(modInfo.modId()).configScreenSupplier();
    }

    public ImmutableList<ModInfo> getAllModsWithConfigScreens() {
        return this.mods;
    }

    @Nullable
    public ModInfo getModInfoFromConfigScreen(Class<? extends GuiBase> clazz) {
        return this.modsMap.values().stream().filter(mod -> mod.configScreenSupplier() != null).filter(mod -> mod.configScreenSupplier().get().getClass() == clazz).findFirst().orElse(null);
    }
}

