/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.gui.ButtonPressDirtyListenerSimple;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.interfaces.IConfigInfoProvider;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOption;
import fi.dy.masa.malilib.gui.widgets.WidgetDropDownList;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.registry.Registry;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.ModInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public abstract class GuiConfigsBase
extends GuiListBase<ConfigOptionWrapper, WidgetConfigOption, WidgetListConfigOptions>
implements IKeybindConfigGui {
    protected WidgetDropDownList<ModInfo> modSwitchWidget;
    protected final List<Runnable> hotkeyChangeListeners = new ArrayList<Runnable>();
    protected final ButtonPressDirtyListenerSimple dirtyListener = new ButtonPressDirtyListenerSimple();
    protected final String modId;
    protected ConfigButtonKeybind activeKeybindButton;
    protected int configWidth = 204;
    @Nullable
    protected IConfigInfoProvider hoverInfoProvider;
    @Nullable
    protected IDialogHandler dialogHandler;

    public GuiConfigsBase(int listX, int listY, String modId, @Nullable class_437 parent, String titleKey, Object ... args) {
        super(listX, listY);
        this.modId = modId;
        this.title = StringUtils.translate(titleKey, args);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buildConfigSwitcher();
    }

    protected void buildConfigSwitcher() {
        final ModInfo thisMod = Registry.CONFIG_SCREEN.getModInfoFromConfigScreen(this.getClass());
        if (thisMod == null) {
            try {
                MaLiLib.debugLog("GuiConfigsBase#initGui(): Attempting to register [{}] ...", this.getModId());
                Registry.CONFIG_SCREEN.registerConfigScreenFactory(new ModInfo(this.getModId(), StringUtils.splitCamelCase(this.getModId()), () -> this));
            }
            catch (Exception ignored) {
                MaLiLib.LOGGER.warn("GuiConfigsBase#initGui(): Failed to automatically register [{}]", (Object)this.getModId());
                return;
            }
        }
        if (thisMod != null && MaLiLibConfigs.Generic.ENABLE_CONFIG_SWITCHER.getBooleanValue()) {
            this.modSwitchWidget = new WidgetDropDownList<ModInfo>(GuiUtils.getScaledWindowWidth() - 155, 6, 130, 18, 200, 10, Registry.CONFIG_SCREEN.getAllModsWithConfigScreens()){
                {
                    super(x, y, width, height, maxHeight, maxVisibleEntries, entries);
                    this.selectedEntry = thisMod;
                }

                @Override
                protected void setSelectedEntry(int index) {
                    super.setSelectedEntry(index);
                    if (this.selectedEntry != null && GuiConfigsBase.this.field_22787 != null && ((ModInfo)this.selectedEntry).configScreenSupplier() != null) {
                        GuiConfigsBase.this.field_22787.method_1507((class_437)((ModInfo)this.selectedEntry).configScreenSupplier().get());
                    }
                }

                @Override
                protected String getDisplayString(ModInfo entry) {
                    return entry.modName();
                }
            };
            this.addWidget(this.modSwitchWidget);
        }
    }

    @Override
    protected int getBrowserWidth() {
        return this.field_22789 - 20;
    }

    @Override
    protected int getBrowserHeight() {
        return this.field_22790 - 80;
    }

    protected boolean useKeybindSearch() {
        return false;
    }

    protected int getConfigWidth() {
        return this.configWidth;
    }

    public GuiConfigsBase setConfigWidth(int configWidth) {
        this.configWidth = configWidth;
        return this;
    }

    public GuiConfigsBase setHoverInfoProvider(IConfigInfoProvider provider) {
        this.hoverInfoProvider = provider;
        return this;
    }

    @Override
    @Nullable
    public IDialogHandler getDialogHandler() {
        return this.dialogHandler;
    }

    public void setDialogHandler(@Nullable IDialogHandler handler) {
        this.dialogHandler = handler;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    @Nullable
    public IConfigInfoProvider getHoverInfoProvider() {
        return this.hoverInfoProvider;
    }

    @Override
    protected WidgetListConfigOptions createListWidget(int listX, int listY) {
        return new WidgetListConfigOptions(listX, listY, this.getBrowserWidth(), this.getBrowserHeight(), this.getConfigWidth(), 0.0f, this.useKeybindSearch(), this);
    }

    @Override
    public void method_25432() {
        if (this.getListWidget() == null) {
            return;
        }
        if (((WidgetListConfigOptions)this.getListWidget()).wereConfigsModified()) {
            ((WidgetListConfigOptions)this.getListWidget()).applyPendingModifications();
            this.onSettingsChanged();
            ((WidgetListConfigOptions)this.getListWidget()).clearConfigsModifiedFlag();
        }
    }

    protected void onSettingsChanged() {
        ConfigManager.getInstance().onConfigsChanged(this.modId);
        if (this.hotkeyChangeListeners.size() > 0) {
            InputEventHandler.getKeybindManager().updateUsedKeys();
        }
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onKeyPressed(input.comp_4795());
            return true;
        }
        if (this.getListWidget() != null && ((WidgetListConfigOptions)this.getListWidget()).onKeyTyped(input)) {
            return true;
        }
        if (input.comp_4795() == 256 && this.getParent() != GuiUtils.getCurrentScreen()) {
            this.closeGui(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCharTyped(class_11905 input) {
        if (this.activeKeybindButton != null) {
            return true;
        }
        if (this.getListWidget() != null && ((WidgetListConfigOptions)this.getListWidget()).onCharTyped(input)) {
            return true;
        }
        return super.onCharTyped(input);
    }

    @Override
    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        if (super.onMouseClicked(click, doubleClick)) {
            return true;
        }
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onClearSelection();
            this.setActiveKeybindButton(null);
            return true;
        }
        return false;
    }

    @Override
    public void clearOptions() {
        this.setActiveKeybindButton(null);
        this.hotkeyChangeListeners.clear();
    }

    @Override
    public void addKeybindChangeListener(Runnable listener) {
        this.hotkeyChangeListeners.add(listener);
    }

    @Override
    public ButtonPressDirtyListenerSimple getButtonPressListener() {
        return this.dirtyListener;
    }

    @Override
    public void setActiveKeybindButton(@Nullable ConfigButtonKeybind button) {
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onClearSelection();
            this.updateKeybindButtons();
        }
        this.activeKeybindButton = button;
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onSelected();
        }
    }

    protected void updateKeybindButtons() {
        for (Runnable listener : this.hotkeyChangeListeners) {
            listener.run();
        }
    }

    public static class ConfigOptionWrapper {
        private final Type type;
        @Nullable
        private final IConfigBase config;
        @Nullable
        private final String label;

        public ConfigOptionWrapper(@Nullable IConfigBase config) {
            this.type = Type.CONFIG;
            this.config = config;
            this.label = null;
        }

        public ConfigOptionWrapper(@Nullable String label) {
            this.type = Type.LABEL;
            this.config = null;
            this.label = label;
        }

        public Type getType() {
            return this.type;
        }

        @Nullable
        public IConfigBase getConfig() {
            return this.config;
        }

        @Nullable
        public String getLabel() {
            return this.label;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public static List<ConfigOptionWrapper> createFor(Collection<? extends IConfigBase> configs) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ImmutableList.Builder builder = ImmutableList.builder();
            for (IConfigBase iConfigBase : configs) {
                builder.add((Object)new ConfigOptionWrapper(iConfigBase));
            }
            return builder.build();
        }

        public static enum Type {
            CONFIG,
            LABEL;

        }
    }
}

