/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.data.CachedTagKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class CachedBlockTags {
    private static final CachedBlockTags INSTANCE = new CachedBlockTags();
    private final HashMap<CachedTagKey, Entry> entries = new HashMap();

    public static CachedBlockTags getInstance() {
        return INSTANCE;
    }

    private CachedBlockTags() {
    }

    public void build(CachedTagKey key, @Nonnull List<String> list) {
        if (list.isEmpty()) {
            MaLiLib.LOGGER.warn("CachedBlockTags#build: list for '{}' is empty.", (Object)key.toString());
            return;
        }
        Entry entry = new Entry(list);
        Entry oldEntry = this.entries.put(key, entry);
        if (oldEntry != null) {
            oldEntry.clear();
        }
        MaLiLib.debugLog("CachedBlockTags#build: New tag list: '{}'", key.toString());
    }

    @Nullable
    public Entry get(CachedTagKey key) {
        if (this.entries.containsKey(key)) {
            return this.entries.get(key);
        }
        return null;
    }

    public void clearEntry(CachedTagKey key) {
        if (this.entries.containsKey(key)) {
            this.entries.get(key).clear();
            MaLiLib.debugLog("CachedBlockTags#clearEntry: Clear tag list Entry: '{}'", key.toString());
        }
    }

    public void clear() {
        this.entries.forEach((name, entry) -> entry.clear());
        MaLiLib.debugLog("CachedBlockTags#clear: Clear all", new Object[0]);
    }

    public List<CachedTagKey> matchAny(class_6880<@NotNull class_2248> block) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(block)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public List<CachedTagKey> matchAny(class_2248 block) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(block)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public List<CachedTagKey> matchAny(class_2680 state) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(state)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public boolean match(CachedTagKey key, class_6880<@NotNull class_2248> block) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(block);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#match(BlockEntry): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public boolean match(CachedTagKey key, class_2248 block) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(block);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#match(Block): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public boolean match(CachedTagKey key, class_2680 state) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(state);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#match(State): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public Optional<Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>>> matchPair(CachedTagKey key, class_6880<@NotNull class_2248> block) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>> pair = entry.matchPair(block);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#matchPair(BlockEntry): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public Optional<Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>>> matchPair(CachedTagKey key, class_2248 block) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>> pair = entry.matchPair(block);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#matchPair(Block): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public Optional<Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>>> matchPair(CachedTagKey key, class_2680 state) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>> pair = entry.matchPair(state);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#matchPair(State): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        this.entries.forEach((key, entry) -> obj.add(key.toString(), entry.toJson()));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        this.entries.clear();
        for (String key : obj.keySet()) {
            if (!obj.isJsonArray()) continue;
            Entry entry = Entry.fromJson(obj.get(key));
            CachedTagKey tagKey = CachedTagKey.fromString(key);
            if (entry == null) continue;
            this.entries.put(tagKey, entry);
        }
    }

    public static class Entry {
        private final HashSet<class_6880<@NotNull class_2248>> blocks = new HashSet();
        private final HashSet<class_6885<@NotNull class_2248>> tags = new HashSet();

        public Entry() {
        }

        public Entry(List<String> list) {
            this();
            this.insertFromList(list);
        }

        public void insertBlock(class_6880<@NotNull class_2248> block) {
            this.blocks.add(block);
        }

        public void insertBlock(class_2248 block) {
            this.insertBlock((class_6880<class_2248>)class_7923.field_41175.method_47983((Object)block));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void insertTag(class_6862<@NotNull class_2248> tag) {
            if (class_310.method_1551().field_1687 != null) {
                @NotNull class_2378 wrapper = class_310.method_1551().field_1687.method_30349().method_30530(class_7923.field_41175.method_46765());
                wrapper.method_46733(tag).ifPresent(this.tags::add);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void insertFromString(String entry) {
            if (entry.startsWith("#")) {
                class_2960 id = class_2960.method_12829((String)entry.substring(1));
                if (id != null) {
                    @NotNull class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id);
                    if (tag != null) {
                        this.insertTag((class_6862<class_2248>)tag);
                    } else {
                        MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block tag '{}'", (Object)entry);
                    }
                } else {
                    MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block tag id '{}'", (Object)entry);
                }
            } else {
                class_2960 id = class_2960.method_12829((String)entry);
                if (id != null) {
                    class_2248 block = (class_2248)class_7923.field_41175.method_63535(id);
                    if (block != null) {
                        this.insertBlock(block);
                    } else {
                        MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block '{}'", (Object)entry);
                    }
                } else {
                    MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block id '{}'", (Object)entry);
                }
            }
        }

        public void insertFromList(List<String> list) {
            if (list.isEmpty()) {
                MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromList: List is empty.");
                return;
            }
            for (String entry : list) {
                this.insertFromString(entry);
            }
        }

        public boolean contains(class_6880<@NotNull class_2248> entry) {
            for (class_6885<class_2248> listEntry : this.tags) {
                if (!listEntry.method_40241(entry)) continue;
                return true;
            }
            return this.blocks.contains(entry);
        }

        public boolean contains(class_2248 block) {
            return this.contains((class_6880<class_2248>)class_7923.field_41175.method_47983((Object)block));
        }

        public boolean contains(class_2680 state) {
            return this.contains(state.method_26204());
        }

        public Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>> matchPair(class_6880<@NotNull class_2248> entry) {
            for (class_6885<class_2248> listEntry : this.tags) {
                if (!listEntry.method_40241(entry)) continue;
                return Pair.of(listEntry, null);
            }
            if (this.blocks.contains(entry)) {
                return Pair.of(null, entry);
            }
            return Pair.of(null, null);
        }

        public Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>> matchPair(class_2248 block) {
            return this.matchPair((class_6880<class_2248>)class_7923.field_41175.method_47983((Object)block));
        }

        public Pair<class_6885<@NotNull class_2248>, class_6880<@NotNull class_2248>> matchPair(class_2680 state) {
            return this.matchPair(state.method_26204());
        }

        public List<String> toList() {
            ArrayList<String> list = new ArrayList<String>();
            this.blocks.forEach(entry -> list.add(entry.method_55840()));
            this.tags.forEach(entry -> list.add("#" + entry.method_45925().toString()));
            return list;
        }

        public JsonElement toJson() {
            JsonArray arr = new JsonArray();
            this.blocks.forEach(entry -> arr.add((JsonElement)new JsonPrimitive(entry.method_55840())));
            this.tags.forEach(entry -> arr.add((JsonElement)new JsonPrimitive("#" + entry.method_45925().toString())));
            return arr;
        }

        @Nullable
        public static Entry fromJson(JsonElement element) {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < arr.size(); ++i) {
                    list.add(arr.get(i).getAsString());
                }
                Entry entry = new Entry();
                entry.insertFromList(list);
                return entry;
            }
            return null;
        }

        public void clear() {
            this.blocks.clear();
            this.tags.clear();
        }
    }
}

