/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options.table.type;

import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.table.type.Entry;
import fi.dy.masa.malilib.config.options.table.type.EntryTypes;

public class BooleanEntry
extends Entry {
    private final IConfigBoolean configBoolean;

    public BooleanEntry(boolean value) {
        this.configBoolean = new ConfigBoolean("", value, "", "", "");
    }

    public static BooleanEntry of(boolean val) {
        return new BooleanEntry(val);
    }

    public boolean getValue() {
        return this.configBoolean.getBooleanValue();
    }

    public void setValue(boolean value) {
        this.configBoolean.setBooleanValue(value);
    }

    @Override
    public EntryTypes getType() {
        return EntryTypes.BOOLEAN;
    }

    @Override
    public JsonObject getAsJsonObject() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", "boolean");
        obj.addProperty("value", String.valueOf(this.configBoolean.getBooleanValue()));
        return obj;
    }

    @Override
    public Entry copy() {
        return new BooleanEntry(this.configBoolean.getBooleanValue());
    }

    @Override
    public boolean wasConfigModified(Entry entry) {
        if (!(entry instanceof BooleanEntry)) {
            return true;
        }
        BooleanEntry other = (BooleanEntry)entry;
        return this.configBoolean.getBooleanValue() != other.configBoolean.getBooleanValue();
    }

    @Override
    public String asString() {
        return Boolean.toString(this.getValue());
    }

    public static BooleanEntry getFromJsonObject(JsonObject obj) {
        boolean val = Boolean.parseBoolean(obj.get("value").getAsString());
        return BooleanEntry.of(val);
    }

    public IConfigBoolean getBooleanValue() {
        return this.configBoolean;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanEntry)) {
            return false;
        }
        BooleanEntry other = (BooleanEntry)o;
        return other.getValue() == this.getValue();
    }
}

