/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigColor;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.IConfigFloat;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IConfigNotifiable;
import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.IStringRepresentable;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.util.data.Color4f;

public class ConfigTypeWrapper
implements IConfigBoolean,
IConfigColor,
IConfigDouble,
IConfigFloat,
IConfigInteger,
IConfigOptionList,
IHotkey,
IConfigNotifiable<IConfigBase> {
    private final ConfigType wrappedType;
    private final IConfigBase wrappedConfig;
    private boolean dirty = false;

    public ConfigTypeWrapper(ConfigType wrappedType, IConfigBase wrappedConfig) {
        this.wrappedType = wrappedType;
        this.wrappedConfig = wrappedConfig;
    }

    @Override
    public boolean shouldUseSlider() {
        if (this.wrappedConfig instanceof IConfigInteger) {
            return ((IConfigInteger)this.wrappedConfig).shouldUseSlider();
        }
        if (this.wrappedConfig instanceof IConfigDouble) {
            return ((IConfigDouble)this.wrappedConfig).shouldUseSlider();
        }
        if (this.wrappedConfig instanceof IConfigFloat) {
            return ((IConfigFloat)this.wrappedConfig).shouldUseSlider();
        }
        return false;
    }

    @Override
    public void toggleUseSlider() {
        if (this.wrappedConfig instanceof IConfigInteger) {
            ((IConfigInteger)this.wrappedConfig).toggleUseSlider();
        } else if (this.wrappedConfig instanceof IConfigDouble) {
            ((IConfigDouble)this.wrappedConfig).toggleUseSlider();
        } else if (this.wrappedConfig instanceof IConfigFloat) {
            ((IConfigFloat)this.wrappedConfig).toggleUseSlider();
        }
    }

    @Override
    public ConfigType getType() {
        return this.wrappedType;
    }

    @Override
    public String getName() {
        return this.wrappedConfig.getName();
    }

    @Override
    public String getLowerName() {
        return this.wrappedConfig.getLowerName();
    }

    @Override
    public String getComment() {
        return this.wrappedConfig.getComment();
    }

    @Override
    public String getPrettyName() {
        return this.wrappedConfig.getPrettyName();
    }

    @Override
    public String getConfigGuiDisplayName() {
        return this.wrappedConfig.getConfigGuiDisplayName();
    }

    @Override
    public String getTranslatedName() {
        return this.wrappedConfig.getTranslatedName();
    }

    @Override
    public void setPrettyName(String prettyName) {
        this.wrappedConfig.setPrettyName(prettyName);
    }

    @Override
    public void setTranslatedName(String translatedName) {
        this.wrappedConfig.setTranslatedName(translatedName);
    }

    @Override
    public void setComment(String comment) {
        this.wrappedConfig.setComment(comment);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void checkIfClean() {
        if (this.isDirty()) {
            this.markClean();
            this.onValueChanged();
        }
    }

    @Override
    public void onValueChanged() {
        if (this.wrappedConfig instanceof IConfigNotifiable) {
            ((IConfigNotifiable)((Object)this.wrappedConfig)).onValueChanged();
        }
    }

    @Override
    public void setValueChangeCallback(IValueChangeCallback<IConfigBase> callback) {
        if (this.wrappedConfig instanceof IConfigNotifiable) {
            ((IConfigNotifiable)((Object)this.wrappedConfig)).setValueChangeCallback(callback);
        }
    }

    @Override
    public String getStringValue() {
        return switch (this.wrappedType) {
            case ConfigType.BOOLEAN -> String.valueOf(((IConfigBoolean)this.wrappedConfig).getBooleanValue());
            case ConfigType.DOUBLE -> String.valueOf(((IConfigDouble)this.wrappedConfig).getDoubleValue());
            case ConfigType.FLOAT -> String.valueOf(((IConfigFloat)this.wrappedConfig).getFloatValue());
            case ConfigType.INTEGER -> String.valueOf(((IConfigInteger)this.wrappedConfig).getIntegerValue());
            case ConfigType.COLOR -> String.format("#%08X", ((IConfigColor)this.wrappedConfig).getIntegerValue());
            case ConfigType.OPTION_LIST -> ((IConfigOptionList)((Object)this.wrappedConfig)).getOptionListValue().getStringValue();
            case ConfigType.HOTKEY -> ((IHotkey)this.wrappedConfig).getKeybind().getStringValue();
            default -> ((IStringRepresentable)((Object)this.wrappedConfig)).getStringValue();
        };
    }

    @Override
    public String getDefaultStringValue() {
        return switch (this.wrappedType) {
            case ConfigType.BOOLEAN -> String.valueOf(((IConfigBoolean)this.wrappedConfig).getDefaultBooleanValue());
            case ConfigType.DOUBLE -> String.valueOf(((IConfigDouble)this.wrappedConfig).getDefaultDoubleValue());
            case ConfigType.FLOAT -> String.valueOf(((IConfigFloat)this.wrappedConfig).getDefaultFloatValue());
            case ConfigType.INTEGER -> String.valueOf(((IConfigInteger)this.wrappedConfig).getDefaultIntegerValue());
            case ConfigType.COLOR -> String.format("#%08X", ((IConfigColor)this.wrappedConfig).getDefaultIntegerValue());
            case ConfigType.OPTION_LIST -> ((IConfigOptionList)((Object)this.wrappedConfig)).getDefaultOptionListValue().getStringValue();
            case ConfigType.HOTKEY -> ((IHotkey)this.wrappedConfig).getKeybind().getDefaultStringValue();
            default -> ((IStringRepresentable)((Object)this.wrappedConfig)).getDefaultStringValue();
        };
    }

    @Override
    public void setValueFromString(String value) {
        try {
            String oldValue = this.getStringValue();
            switch (this.wrappedType) {
                case HOTKEY: {
                    ((IHotkey)this.wrappedConfig).getKeybind().setValueFromString(value);
                    break;
                }
                case BOOLEAN: {
                    ((IConfigBoolean)this.wrappedConfig).setBooleanValue(Boolean.parseBoolean(value));
                    break;
                }
                case DOUBLE: {
                    ((IConfigDouble)this.wrappedConfig).setDoubleValue(Double.parseDouble(value));
                    break;
                }
                case FLOAT: {
                    ((IConfigFloat)this.wrappedConfig).setFloatValue(Float.parseFloat(value));
                    break;
                }
                case INTEGER: {
                    ((IConfigInteger)this.wrappedConfig).setIntegerValue(Integer.parseInt(value));
                    break;
                }
                case STRING: {
                    ((IStringRepresentable)((Object)this.wrappedConfig)).setValueFromString(value);
                    break;
                }
                case COLOR: {
                    ((IConfigColor)this.wrappedConfig).setValueFromString(value);
                    break;
                }
                case OPTION_LIST: {
                    IConfigOptionList option = (IConfigOptionList)((Object)this.wrappedConfig);
                    option.setOptionListValue(option.getOptionListValue().fromString(value));
                    break;
                }
            }
            if (!oldValue.equals(this.getStringValue())) {
                this.onValueChanged();
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set the config value for '{}' from string '{}'", (Object)this.getName(), (Object)value, (Object)e);
        }
    }

    @Override
    public boolean isModified() {
        return switch (this.wrappedType) {
            case ConfigType.HOTKEY -> ((IHotkey)this.wrappedConfig).getKeybind().isModified();
            case ConfigType.BOOLEAN -> {
                IConfigBoolean config = (IConfigBoolean)this.wrappedConfig;
                if (config.getBooleanValue() != config.getDefaultBooleanValue()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.DOUBLE -> {
                IConfigDouble config = (IConfigDouble)this.wrappedConfig;
                if (config.getDoubleValue() != config.getDefaultDoubleValue()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.FLOAT -> {
                IConfigFloat config = (IConfigFloat)this.wrappedConfig;
                if (config.getFloatValue() != config.getDefaultFloatValue()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.INTEGER -> {
                IConfigInteger config = (IConfigInteger)this.wrappedConfig;
                if (config.getIntegerValue() != config.getDefaultIntegerValue()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.COLOR -> {
                IConfigColor config = (IConfigColor)this.wrappedConfig;
                if (config.getIntegerValue() != config.getDefaultIntegerValue()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.OPTION_LIST -> {
                IConfigOptionList config = (IConfigOptionList)((Object)this.wrappedConfig);
                if (config.getOptionListValue() != config.getDefaultOptionListValue()) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.STRING -> {
                IStringRepresentable config = (IStringRepresentable)((Object)this.wrappedConfig);
                if (!config.getStringValue().equals(config.getDefaultStringValue())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public boolean isModified(String newValue) {
        return switch (this.wrappedType) {
            case ConfigType.HOTKEY -> ((IHotkey)this.wrappedConfig).getKeybind().isModified(newValue);
            case ConfigType.BOOLEAN -> {
                if (!String.valueOf(((IConfigBoolean)this.wrappedConfig).getBooleanValue()).equals(newValue)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.DOUBLE -> {
                if (!String.valueOf(((IConfigDouble)this.wrappedConfig).getDoubleValue()).equals(newValue)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.FLOAT -> {
                if (!String.valueOf(((IConfigFloat)this.wrappedConfig).getFloatValue()).equals(newValue)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.INTEGER -> {
                if (!String.valueOf(((IConfigInteger)this.wrappedConfig).getIntegerValue()).equals(newValue)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.COLOR -> {
                if (!((ConfigColor)this.wrappedConfig).getStringValue().equals(newValue)) {
                    yield true;
                }
                yield false;
            }
            case ConfigType.OPTION_LIST -> {
                if (!((IConfigOptionList)((Object)this.wrappedConfig)).getOptionListValue().getStringValue().equals(newValue)) {
                    yield true;
                }
                yield false;
            }
            default -> !((IStringRepresentable)((Object)this.wrappedConfig)).getStringValue().equals(newValue);
        };
    }

    @Override
    public void resetToDefault() {
        try {
            String oldValue = this.getStringValue();
            switch (this.wrappedType) {
                case HOTKEY: {
                    ((IHotkey)this.wrappedConfig).getKeybind().resetToDefault();
                    break;
                }
                case BOOLEAN: {
                    IConfigBoolean config = (IConfigBoolean)this.wrappedConfig;
                    config.setBooleanValue(config.getDefaultBooleanValue());
                    break;
                }
                case DOUBLE: {
                    IConfigDouble config = (IConfigDouble)this.wrappedConfig;
                    config.setDoubleValue(config.getDefaultDoubleValue());
                    break;
                }
                case FLOAT: {
                    IConfigFloat config = (IConfigFloat)this.wrappedConfig;
                    config.setFloatValue(config.getDefaultFloatValue());
                    break;
                }
                case INTEGER: {
                    IConfigInteger config = (IConfigInteger)this.wrappedConfig;
                    config.setIntegerValue(config.getDefaultIntegerValue());
                    break;
                }
                case COLOR: {
                    IConfigColor config = (IConfigColor)this.wrappedConfig;
                    config.setIntegerValue(config.getDefaultIntegerValue());
                    break;
                }
                case OPTION_LIST: {
                    IConfigOptionList config = (IConfigOptionList)((Object)this.wrappedConfig);
                    config.setOptionListValue(config.getDefaultOptionListValue());
                    break;
                }
                default: {
                    IStringRepresentable config = (IStringRepresentable)((Object)this.wrappedConfig);
                    config.setValueFromString(config.getDefaultStringValue());
                    break;
                }
            }
            if (!oldValue.equals(this.getStringValue())) {
                this.onValueChanged();
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to reset config value for {}", (Object)this.getName(), (Object)e);
        }
    }

    @Override
    public boolean getBooleanValue() {
        return this.wrappedType == ConfigType.BOOLEAN ? ((IConfigBoolean)this.wrappedConfig).getBooleanValue() : false;
    }

    @Override
    public boolean getDefaultBooleanValue() {
        return this.wrappedType == ConfigType.BOOLEAN ? ((IConfigBoolean)this.wrappedConfig).getDefaultBooleanValue() : false;
    }

    @Override
    public void setBooleanValue(boolean value) {
        boolean oldValue = this.getBooleanValue();
        if (this.wrappedType == ConfigType.BOOLEAN) {
            ((IConfigBoolean)this.wrappedConfig).setBooleanValue(value);
        }
        if (oldValue != this.getBooleanValue()) {
            this.onValueChanged();
        }
    }

    @Override
    public Color4f getColor() {
        return this.wrappedType == ConfigType.COLOR ? ((IConfigColor)this.wrappedConfig).getColor() : Color4f.ZERO;
    }

    @Override
    public int getIntegerValue() {
        if (this.wrappedType == ConfigType.INTEGER) {
            return ((IConfigInteger)this.wrappedConfig).getIntegerValue();
        }
        if (this.wrappedType == ConfigType.COLOR) {
            return ((IConfigColor)this.wrappedConfig).getIntegerValue();
        }
        return 0;
    }

    @Override
    public int getDefaultIntegerValue() {
        if (this.wrappedType == ConfigType.INTEGER) {
            return ((IConfigInteger)this.wrappedConfig).getDefaultIntegerValue();
        }
        if (this.wrappedType == ConfigType.COLOR) {
            return ((IConfigColor)this.wrappedConfig).getDefaultIntegerValue();
        }
        return 0;
    }

    @Override
    public void setIntegerValue(int value) {
        int oldValue = this.getIntegerValue();
        if (this.wrappedType == ConfigType.INTEGER) {
            ((IConfigInteger)this.wrappedConfig).setIntegerValue(value);
        } else if (this.wrappedType == ConfigType.COLOR) {
            ((IConfigColor)this.wrappedConfig).setIntegerValue(value);
        }
        if (oldValue != this.getIntegerValue()) {
            this.onValueChanged();
        }
    }

    @Override
    public int getMinIntegerValue() {
        if (this.wrappedType == ConfigType.INTEGER) {
            return ((IConfigInteger)this.wrappedConfig).getMinIntegerValue();
        }
        if (this.wrappedType == ConfigType.COLOR) {
            return ((IConfigColor)this.wrappedConfig).getMinIntegerValue();
        }
        return 0;
    }

    @Override
    public int getMaxIntegerValue() {
        if (this.wrappedType == ConfigType.INTEGER) {
            return ((IConfigInteger)this.wrappedConfig).getMaxIntegerValue();
        }
        if (this.wrappedType == ConfigType.COLOR) {
            return ((IConfigColor)this.wrappedConfig).getMaxIntegerValue();
        }
        return 0;
    }

    @Override
    public double getDoubleValue() {
        return this.wrappedType == ConfigType.DOUBLE ? ((IConfigDouble)this.wrappedConfig).getDoubleValue() : 0.0;
    }

    @Override
    public double getDefaultDoubleValue() {
        return this.wrappedType == ConfigType.DOUBLE ? ((IConfigDouble)this.wrappedConfig).getDefaultDoubleValue() : 0.0;
    }

    @Override
    public void setDoubleValue(double value) {
        double oldValue = this.getDoubleValue();
        if (this.wrappedType == ConfigType.DOUBLE) {
            ((IConfigDouble)this.wrappedConfig).setDoubleValue(value);
        }
        if (oldValue != this.getDoubleValue()) {
            this.onValueChanged();
        }
    }

    @Override
    public double getMinDoubleValue() {
        return this.wrappedType == ConfigType.DOUBLE ? ((IConfigDouble)this.wrappedConfig).getMinDoubleValue() : 0.0;
    }

    @Override
    public double getMaxDoubleValue() {
        return this.wrappedType == ConfigType.DOUBLE ? ((IConfigDouble)this.wrappedConfig).getMaxDoubleValue() : 0.0;
    }

    @Override
    public float getFloatValue() {
        return this.wrappedType == ConfigType.FLOAT ? ((IConfigFloat)this.wrappedConfig).getFloatValue() : 0.0f;
    }

    @Override
    public float getDefaultFloatValue() {
        return this.wrappedType == ConfigType.FLOAT ? ((IConfigFloat)this.wrappedConfig).getDefaultFloatValue() : 0.0f;
    }

    @Override
    public void setFloatValue(float value) {
        float oldValue = this.getFloatValue();
        if (this.wrappedType == ConfigType.FLOAT) {
            ((IConfigFloat)this.wrappedConfig).setFloatValue(value);
        }
        if (oldValue != this.getFloatValue()) {
            this.onValueChanged();
        }
    }

    @Override
    public float getMinFloatValue() {
        return this.wrappedType == ConfigType.FLOAT ? ((IConfigFloat)this.wrappedConfig).getMinFloatValue() : 0.0f;
    }

    @Override
    public float getMaxFloatValue() {
        return this.wrappedType == ConfigType.FLOAT ? ((IConfigFloat)this.wrappedConfig).getMaxFloatValue() : 0.0f;
    }

    @Override
    public IConfigOptionListEntry getOptionListValue() {
        return this.wrappedType == ConfigType.OPTION_LIST ? ((IConfigOptionList)((Object)this.wrappedConfig)).getOptionListValue() : null;
    }

    @Override
    public IConfigOptionListEntry getDefaultOptionListValue() {
        return this.wrappedType == ConfigType.OPTION_LIST ? ((IConfigOptionList)((Object)this.wrappedConfig)).getDefaultOptionListValue() : null;
    }

    @Override
    public void setOptionListValue(IConfigOptionListEntry value) {
        IConfigOptionListEntry oldValue = this.getOptionListValue();
        if (this.wrappedType == ConfigType.OPTION_LIST) {
            ((IConfigOptionList)((Object)this.wrappedConfig)).setOptionListValue(value);
        }
        if (oldValue != this.getOptionListValue()) {
            this.onValueChanged();
        }
    }

    @Override
    public IKeybind getKeybind() {
        return this.wrappedType == ConfigType.HOTKEY ? ((IHotkey)this.wrappedConfig).getKeybind() : null;
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        try {
            String oldValue = this.getStringValue();
            switch (this.wrappedType) {
                case BOOLEAN: {
                    ((IConfigBoolean)this.wrappedConfig).setBooleanValue(element.getAsBoolean());
                    break;
                }
                case DOUBLE: {
                    ((IConfigDouble)this.wrappedConfig).setDoubleValue(element.getAsDouble());
                    break;
                }
                case FLOAT: {
                    ((IConfigFloat)this.wrappedConfig).setFloatValue(element.getAsFloat());
                    break;
                }
                case INTEGER: {
                    ((IConfigInteger)this.wrappedConfig).setIntegerValue(element.getAsInt());
                    break;
                }
                case STRING: {
                    ((IConfigValue)this.wrappedConfig).setValueFromString(element.getAsString());
                    break;
                }
                case COLOR: {
                    ((IConfigColor)this.wrappedConfig).setValueFromString(element.getAsString());
                    break;
                }
                case OPTION_LIST: {
                    IConfigOptionList option = (IConfigOptionList)((Object)this.wrappedConfig);
                    option.setOptionListValue(option.getOptionListValue().fromString(element.getAsString()));
                    break;
                }
                case HOTKEY: {
                    ((IHotkey)this.wrappedConfig).setValueFromJsonElement(element);
                    break;
                }
            }
            if (!oldValue.equals(this.getStringValue())) {
                this.onValueChanged();
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        return switch (this.wrappedType) {
            case ConfigType.BOOLEAN -> new JsonPrimitive(Boolean.valueOf(((IConfigBoolean)this.wrappedConfig).getBooleanValue()));
            case ConfigType.DOUBLE -> new JsonPrimitive((Number)((IConfigDouble)this.wrappedConfig).getDoubleValue());
            case ConfigType.FLOAT -> new JsonPrimitive((Number)Float.valueOf(((IConfigFloat)this.wrappedConfig).getFloatValue()));
            case ConfigType.INTEGER -> new JsonPrimitive((Number)((IConfigInteger)this.wrappedConfig).getIntegerValue());
            case ConfigType.STRING -> new JsonPrimitive(((IConfigValue)this.wrappedConfig).getStringValue());
            case ConfigType.COLOR -> new JsonPrimitive(((IConfigColor)this.wrappedConfig).getStringValue());
            case ConfigType.OPTION_LIST -> new JsonPrimitive(((IConfigOptionList)((Object)this.wrappedConfig)).getOptionListValue().getStringValue());
            case ConfigType.HOTKEY -> ((IHotkey)this.wrappedConfig).getAsJsonElement();
            default -> new JsonPrimitive(this.getStringValue());
        };
    }
}

