/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeSpawnSphere;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class ShapeEllipsoidSpawn
extends ShapeSpawnSphere {
    protected double radiusY;
    protected double radiusZ;

    public ShapeEllipsoidSpawn() {
        this(ShapeType.ELLIPSOID_SPAWN, Configs.Colors.SHAPE_ADJUSTABLE_SPAWN_SPHERE.getColor(), 24.0);
    }

    public ShapeEllipsoidSpawn(ShapeType type, Color4f color, double radius) {
        super(type, color, radius);
        this.radiusY = radius;
        this.radiusZ = radius;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public void setRadiusY(double radiusY) {
        this.radiusY = class_3532.method_15350((double)radiusY, (double)0.0, (double)1024.0);
        this.setNeedsUpdate();
    }

    public void setRadiusZ(double radiusZ) {
        this.radiusZ = class_3532.method_15350((double)radiusZ, (double)0.0, (double)1024.0);
        this.setNeedsUpdate();
    }

    @Override
    protected SphereUtils.RingPositionTest getPositionTest() {
        return this::isPositionOnOrInsideEllipsoidRing;
    }

    protected boolean isPositionOnOrInsideEllipsoidRing(int x, int y, int z, class_2350 outSide) {
        double rz;
        double dz;
        double ry;
        double dy;
        class_243 center = this.getEffectiveCenter();
        double dx = (double)x + 0.5 - center.field_1352;
        double rx = this.getRadius();
        double normalizedDist = dx * dx / (rx * rx) + (dy = (double)y + 0.5 - center.field_1351) * dy / ((ry = this.radiusY) * ry) + (dz = (double)z + 0.5 - center.field_1350) * dz / ((rz = this.radiusZ) * rz);
        return normalizedDist <= 1.0;
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        lines.add(4, StringUtils.translate((String)"minihud.gui.hover.shape.radius_y_value", (Object[])new Object[]{ShapeEllipsoidSpawn.d2(this.radiusY)}));
        lines.add(5, StringUtils.translate((String)"minihud.gui.hover.shape.radius_z_value", (Object[])new Object[]{ShapeEllipsoidSpawn.d2(this.radiusZ)}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("radius_y", (JsonElement)new JsonPrimitive((Number)this.radiusY));
        obj.add("radius_z", (JsonElement)new JsonPrimitive((Number)this.radiusZ));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.radiusY = JsonUtils.hasDouble((JsonObject)obj, (String)"radius_y") ? JsonUtils.getDouble((JsonObject)obj, (String)"radius_y") : this.getRadius();
        this.radiusZ = JsonUtils.hasDouble((JsonObject)obj, (String)"radius_z") ? JsonUtils.getDouble((JsonObject)obj, (String)"radius_z") : this.getRadius();
        this.setNeedsUpdate();
    }
}

