/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_9801;

public class OverlayRendererRegion
extends OverlayRendererBase {
    public static final OverlayRendererRegion INSTANCE = new OverlayRendererRegion();
    protected boolean needsUpdate = true;
    private List<class_238> boxes = new ArrayList<class_238>();
    private boolean hasData = false;

    protected OverlayRendererRegion() {
        this.useCulling = false;
        this.renderThrough = false;
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public String getName() {
        return "Region";
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_REGION_FILE.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (this.needsUpdate) {
            return true;
        }
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        return ex >> 9 != lx >> 9 || ez >> 9 != lz >> 9 || Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        this.calculateRegions(entity);
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
        this.needsUpdate = false;
    }

    private void calculateRegions(class_1297 entity) {
        class_1937 world = entity.method_73183();
        int minY = world != null ? world.method_31607() : -64;
        int maxY = world != null ? world.method_31600() + 1 : 320;
        int rx = class_3532.method_15357((double)entity.method_23317()) & 0xFFFFFE00;
        int rz = class_3532.method_15357((double)entity.method_23321()) & 0xFFFFFE00;
        class_2338 pos1 = new class_2338(rx, minY, rz);
        class_2338 pos2 = new class_2338(rx + 511, maxY, rz + 511);
        this.boxes = RenderUtils.calculateBoxes(pos1, pos2);
        this.hasData = true;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.boxes.isEmpty();
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("region_quads");
        Color4f color = Configs.Colors.REGION_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:region/quads", MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL);
        for (class_238 box : this.boxes) {
            RenderUtils.renderWallQuads(box, cameraPos, color, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererRegion#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("region_outlines");
        Color4f color = Configs.Colors.REGION_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:region/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        for (class_238 box : this.boxes) {
            RenderUtils.renderWallOutlines(box, 16.0, 16.0, true, cameraPos, color, this.glLineWidth, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererRegion#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.boxes.clear();
        this.hasData = false;
    }
}

