/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.generic;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.time.TickUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class InfoLineServerTPS
extends InfoLine {
    private static final String TPS_KEY = "minihud.info_line.server_tps";

    public InfoLineServerTPS(InfoToggle type) {
        super(type);
    }

    public InfoLineServerTPS() {
        this(InfoToggle.SERVER_TPS);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLineContext ctx) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (TickUtils.isValid()) {
            String append;
            String preTps;
            double tps = TickUtils.hasDirectData() ? TickUtils.getDirectTPS() : TickUtils.getMeasuredTPS();
            double mspt = TickUtils.hasDirectData() ? TickUtils.getDirectMSPT() : TickUtils.getMeasuredMSPT();
            boolean isSprinting = TickUtils.isSprinting();
            boolean isFrozen = TickUtils.isFrozen();
            StringBuilder builder = new StringBuilder();
            String rst = GuiBase.TXT_RST;
            String string = preTps = tps >= 20.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
            String string2 = isSprinting ? this.qt("minihud.info_line.server_tps.sprinting", new Object[0]) : (append = isFrozen ? this.qt("minihud.info_line.server_tps.frozen", new Object[0]) : "");
            if (this.getHudData().hasServuxServer() && TickUtils.hasServuxData() || this.getData().hasCarpetServer() && TickUtils.hasDirectData() || this.getData().isSinglePlayer() && this.getData().hasIntegratedServer()) {
                String preMspt = mspt <= 40.0 ? GuiBase.TXT_GREEN : (mspt <= 45.0 ? GuiBase.TXT_YELLOW : (mspt <= 50.0 ? GuiBase.TXT_GOLD : GuiBase.TXT_RED));
                builder.append(this.qt(TPS_KEY, preTps, tps, rst, preMspt, mspt, rst));
                if (!append.isEmpty()) {
                    builder.append(append);
                }
                list.add(this.of(builder.toString()));
            } else {
                String preMspt = mspt <= 51.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                builder.append(this.qt("minihud.info_line.server_tps.est", preTps, tps, rst, preMspt, mspt, rst));
                if (!append.isEmpty()) {
                    builder.append(append);
                }
                list.add(this.of(builder.toString()));
            }
        } else {
            list.add(this.translate("minihud.info_line.server_tps.invalid", new Object[0]));
        }
        return list;
    }
}

