/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1433;
import net.minecraft.class_1937;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLineDolphinTreasure
extends InfoLine {
    private static final String DOLPHIN_KEY = "minihud.info_line.dolphin_treasure";

    public InfoLineDolphinTreasure(InfoToggle type) {
        super(type);
    }

    public InfoLineDolphinTreasure() {
        super(InfoToggle.DOLPHIN_TREASURE);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLineContext ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasData()) {
            class_1299 entityType = DataEntityUtils.getEntityType((CompoundData)ctx.data());
            if (entityType == null) {
                return null;
            }
            return this.parseData(ctx.world(), entityType, ctx.data());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseData(@NotNull class_1937 world, @NotNull class_1299<?> entityType, @NotNull CompoundData data) {
        Pair dolphiPair = DataEntityUtils.getDolphinData((CompoundData)data);
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (dolphiPair != null && entityType.equals((Object)class_1299.field_6087)) {
            int dryTime = (Integer)dolphiPair.getLeft();
            if (dryTime > 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.drying_no_treasure", MiscUtils.formatDuration((long)(dryTime / 20) * 1000L)));
            } else if (dryTime < 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.dying_no_treasure", MiscUtils.formatDuration((long)(dryTime * -1 / 20) * 1000L)));
            }
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@NotNull class_1937 world, @NotNull class_1297 ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof class_1433) {
            class_1433 dolphin = (class_1433)ent;
            int dryTime = dolphin.method_6491();
            if (dryTime > 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.drying_no_treasure", MiscUtils.formatDuration((long)(dryTime / 20) * 1000L)));
            } else if (dryTime < 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.dying_no_treasure", MiscUtils.formatDuration((long)(dryTime * -1 / 20) * 1000L)));
            }
        }
        return list;
    }
}

