/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.camera;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;

public abstract class InfoLineCoordinatesDimensionBase
extends InfoLine {
    private static final String COORD_KEY = "minihud.info_line.coordinates";
    private static final String COORD_SCALED_KEY = "minihud.info_line.coordinates_scaled";
    private static final String DIM_KEY = "minihud.info_line.dimension";

    public InfoLineCoordinatesDimensionBase(InfoToggle type) {
        super(type);
    }

    public InfoLineCoordinatesDimensionBase() {
        this(InfoToggle.COORDINATES);
    }

    @Override
    public boolean succeededType() {
        return this.succeeded;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLineContext ctx) {
        if (ctx.world() == null || ctx.ent() == null) {
            return null;
        }
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        String pre = "";
        StringBuilder str = new StringBuilder(128);
        String fmtStr = Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue();
        double x = ctx.ent().method_23317();
        double y = ctx.ent().method_23318();
        double z = ctx.ent().method_23321();
        if (InfoToggle.COORDINATES.getBooleanValue()) {
            if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                try {
                    str.append(String.format(fmtStr, x, y, z));
                }
                catch (Exception e) {
                    str.append(this.qt("minihud.info_line.coordinates.exception", new Object[0]));
                }
            } else {
                str.append(this.qt("minihud.info_line.coordinates.format", x, y, z));
            }
            pre = " / ";
        }
        if (InfoToggle.COORDINATES_SCALED.getBooleanValue() && (ctx.world().method_27983() == class_1937.field_25180 || ctx.world().method_27983() == class_1937.field_25179)) {
            boolean isNether = ctx.world().method_27983() == class_1937.field_25180;
            double scale = isNether ? 8.0 : 0.125;
            x *= scale;
            z *= scale;
            str.append(pre);
            if (isNether) {
                str.append(this.qt("minihud.info_line.coordinates_scaled.overworld", new Object[0]));
            } else {
                str.append(this.qt("minihud.info_line.coordinates_scaled.nether", new Object[0]));
            }
            if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                try {
                    str.append(String.format(fmtStr, x, y, z));
                }
                catch (Exception e) {
                    str.append(this.qt("minihud.info_line.coordinates.exception", new Object[0]));
                }
            } else {
                str.append(this.qt("minihud.info_line.coordinates.format", x, y, z));
            }
            pre = " / ";
        }
        if (InfoToggle.DIMENSION.getBooleanValue()) {
            String dimName = ctx.world().method_27983().method_29177().toString();
            str.append(pre).append(this.qt(DIM_KEY, new Object[0])).append(dimName);
        }
        list.add(this.of(str.toString()));
        this.succeeded = true;
        return list;
    }
}

