/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.InventoryOverlayType;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import fi.dy.masa.tweakeroo.util.SnapAimUtils;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9304;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class RenderUtils {
    private static long lastRotationChangeTime;

    public static void renderHotbarSwapOverlay(GuiContext ctx) {
        class_746 player = ctx.mc().field_1724;
        if (player != null && ctx.mc().field_1755 == null) {
            int scaledWidth = GuiUtils.getScaledWindowWidth();
            int scaledHeight = GuiUtils.getScaledWindowHeight();
            int offX = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_X.getIntegerValue();
            int offY = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_Y.getIntegerValue();
            int startX = offX;
            int startY = offY;
            HudAlignment align = (HudAlignment)Configs.Generic.HOTBAR_SWAP_OVERLAY_ALIGNMENT.getOptionListValue();
            switch (align) {
                case TOP_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    break;
                }
                case BOTTOM_LEFT: {
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case BOTTOM_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case CENTER: {
                    startX = scaledWidth / 2 - offX - 81;
                    startY = scaledHeight / 2 - offY - 27;
                    break;
                }
            }
            int x = startX;
            int y = startY;
            class_327 textRenderer = ctx.fontRenderer();
            Matrix4f modelViewMatrix = new Matrix4f();
            modelViewMatrix.set((Matrix4fc)RenderSystem.getModelViewMatrix());
            fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((GuiContext)ctx, (class_2960)class_465.field_2801, (int)(x - 1), (int)(y - 1), (int)7, (int)83, (int)162, (int)54);
            ctx.method_25303(textRenderer, "1", x - 10, y + 4, 0xFFFFFF);
            ctx.method_25303(textRenderer, "2", x - 10, y + 22, 0xFFFFFF);
            ctx.method_25303(textRenderer, "3", x - 10, y + 40, 0xFFFFFF);
            for (int row = 1; row <= 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    class_1799 stack = player.method_31548().method_5438(row * 9 + column);
                    if (!stack.method_7960()) {
                        InventoryOverlay.renderStackAt((GuiContext)ctx, (class_1799)stack, (float)x, (float)y, (float)1.0f);
                    }
                    x += 18;
                }
                y += 18;
                x = startX;
            }
            RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
        }
    }

    public static void renderPlayerInventoryOverlay(GuiContext ctx) {
        if (ctx.mc().field_1724 == null) {
            return;
        }
        class_1661 inv = ctx.mc().field_1724.method_31548();
        int x = GuiUtils.getScaledWindowWidth() / 2 - 88;
        int y = GuiUtils.getScaledWindowHeight() / 2 + 10;
        int slotOffsetX = 8;
        int slotOffsetY = 8;
        InventoryOverlayType type = InventoryOverlayType.GENERIC;
        InventoryOverlay.renderInventoryBackground((GuiContext)ctx, (InventoryOverlayType)type, (int)x, (int)y, (int)9, (int)27);
        InventoryOverlay.renderInventoryStacks((GuiContext)ctx, (InventoryOverlayType)type, (class_1263)inv, (int)(x + slotOffsetX), (int)(y + slotOffsetY), (int)9, (int)9, (int)27);
    }

    public static void renderHotbarScrollOverlay(GuiContext ctx) {
        if (ctx.mc().field_1724 == null) {
            return;
        }
        class_1661 inv = ctx.mc().field_1724.method_31548();
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 88;
        int y = yCenter + 6;
        InventoryOverlayType type = InventoryOverlayType.GENERIC;
        InventoryOverlay.renderInventoryBackground((GuiContext)ctx, (InventoryOverlayType)type, (int)x, (int)y, (int)9, (int)27);
        InventoryOverlay.renderInventoryBackground((GuiContext)ctx, (InventoryOverlayType)type, (int)x, (int)(y + 70), (int)9, (int)9);
        InventoryOverlay.renderInventoryStacks((GuiContext)ctx, (InventoryOverlayType)type, (class_1263)inv, (int)(x + 8), (int)(y + 8), (int)9, (int)9, (int)27);
        InventoryOverlay.renderInventoryStacks((GuiContext)ctx, (InventoryOverlayType)type, (class_1263)inv, (int)(x + 8), (int)(y + 78), (int)9, (int)0, (int)9);
        int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((GuiContext)ctx, (int)(x + 5), (int)(y + currentRow * 18 + 5), (int)166, (int)22, (int)2, (int)-57312);
    }

    public static float calculateLiquidFogDistance(class_1297 entity, float originalFog, boolean water) {
        class_1309 living;
        class_1799 head;
        if (entity instanceof class_1309 && !(head = (living = (class_1309)entity).method_6118(class_1304.field_6169)).method_7960()) {
            class_9304 enchants = head.method_58657();
            float lavaFog = originalFog > 1.0f ? 3.3f : 1.3f;
            float fog = water ? originalFog / 4.0f : lavaFog;
            int resp = 0;
            int aqua = 0;
            if (!enchants.equals((Object)class_9304.field_49385)) {
                Set enchantList = enchants.method_57534();
                for (class_6880 entry : enchantList) {
                    if (entry.method_40225(class_1893.field_9105)) {
                        aqua = enchants.method_57536(entry);
                    }
                    if (!entry.method_40225(class_1893.field_9127)) continue;
                    resp = enchants.method_57536(entry);
                }
            }
            if (aqua > 0) {
                fog *= 1.6f;
            }
            if (resp > 0) {
                fog *= (float)resp * 1.6f;
            }
            if (water) {
                fog = Math.max(fog / 2.8f, originalFog / 4.4f) + originalFog;
            }
            return Math.max(fog, originalFog);
        }
        return originalFog;
    }

    public static void notifyRotationChanged() {
        lastRotationChangeTime = System.currentTimeMillis();
    }

    public static void renderSnapAimAngleIndicator(GuiContext ctx) {
        long current = System.currentTimeMillis();
        if (current - lastRotationChangeTime < 750L) {
            class_310 mc = class_310.method_1551();
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
            if (mode != SnapAimMode.PITCH) {
                RenderUtils.renderSnapAimAngleIndicatorYaw(ctx, xCenter, yCenter, 80, 12);
            }
            if (mode != SnapAimMode.YAW) {
                RenderUtils.renderSnapAimAngleIndicatorPitch(ctx, xCenter, yCenter, 12, 50);
            }
        }
    }

    private static void renderSnapAimAngleIndicatorYaw(GuiContext ctx, int xCenter, int yCenter, int width, int height) {
        double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
        double realYaw = class_3532.method_15367((double)SnapAimUtils.getLastRealYaw(), (double)360.0);
        double snappedYaw = SnapAimUtils.calculateSnappedAngle(realYaw, step);
        double startYaw = snappedYaw - step / 2.0;
        int x = xCenter - width / 2;
        int y = yCenter + 10;
        int lineX = x + (int)(class_3532.method_15338((double)(realYaw - startYaw)) / step * (double)width);
        class_327 textRenderer = ctx.fontRenderer();
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((GuiContext)ctx, (int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        String str = class_3532.method_15338((double)snappedYaw) + "\u00b0";
        ctx.method_51433(textRenderer, str, xCenter - textRenderer.method_1727(str) / 2, y + height + 2, -1, false);
        str = "<  " + class_3532.method_15338((double)(snappedYaw - step)) + "\u00b0";
        ctx.method_51433(textRenderer, str, x - textRenderer.method_1727(str), y + height + 2, -1, false);
        str = class_3532.method_15338((double)(snappedYaw + step)) + "\u00b0  >";
        ctx.method_51433(textRenderer, str, x + width, y + height + 2, -1, false);
        if (Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_YAW.getDoubleValue();
            int snapThreshOffset = (int)((double)width * threshold / step);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)(xCenter - snapThreshOffset), (int)y, (int)(snapThreshOffset * 2), (int)height, (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)(xCenter - snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)(xCenter + snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
            }
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)lineX, (int)y, (int)2, (int)height, (int)-1);
    }

    private static void renderSnapAimAngleIndicatorPitch(GuiContext ctx, int xCenter, int yCenter, int width, int height) {
        double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
        int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
        double realPitch = class_3532.method_15338((double)SnapAimUtils.getLastRealPitch());
        double snappedPitch = realPitch < 0.0 ? -SnapAimUtils.calculateSnappedAngle(-realPitch, step) : SnapAimUtils.calculateSnappedAngle(realPitch, step);
        snappedPitch = class_3532.method_15350((double)class_3532.method_15338((double)snappedPitch), (double)(-limit), (double)limit);
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        RenderUtils.renderPitchIndicator(ctx, x, y, width, height, realPitch, snappedPitch, step, true);
    }

    public static void renderPitchLockIndicator(GuiContext ctx) {
        if (ctx.mc().field_1724 == null) {
            return;
        }
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int width = 12;
        int height = 50;
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        double currentPitch = ctx.mc().field_1724.method_36455();
        double centerPitch = 0.0;
        double indicatorRange = 180.0;
        RenderUtils.renderPitchIndicator(ctx, x, y, width, height, currentPitch, centerPitch, indicatorRange, false);
    }

    private static void renderPitchIndicator(GuiContext ctx, int x, int y, int width, int height, double currentPitch, double centerPitch, double indicatorRange, boolean isSnapRange) {
        double startPitch = centerPitch - indicatorRange / 2.0;
        double printedRange = isSnapRange ? indicatorRange : indicatorRange / 2.0;
        int lineY = y + (int)((class_3532.method_15338((double)currentPitch) - startPitch) / indicatorRange * (double)height);
        double angleUp = centerPitch - printedRange;
        double angleDown = centerPitch + printedRange;
        class_327 textRenderer = ctx.fontRenderer();
        if (isSnapRange) {
            String strUp = String.format("%6.1f\u00b0 ^", class_3532.method_15338((double)angleUp));
            String strDown = String.format("%6.1f\u00b0 v", class_3532.method_15338((double)angleDown));
            ctx.method_51433(textRenderer, strUp, x + width + 4, y - 4, -1, false);
            ctx.method_51433(textRenderer, strDown, x + width + 4, y + height - 4, -1, false);
            String str = String.format("%6.1f\u00b0", class_3532.method_15338((double)(isSnapRange ? centerPitch : currentPitch)));
            ctx.method_51433(textRenderer, str, x + width + 4, y + height / 2 - 4, -1, false);
        } else {
            String str = String.format("%4.1f\u00b0", class_3532.method_15338((double)(isSnapRange ? centerPitch : currentPitch)));
            ctx.method_51433(textRenderer, str, x + width + 4, lineY - 4, -1, false);
        }
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((GuiContext)ctx, (int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        int yCenter = y + height / 2 - 1;
        if (isSnapRange && Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_PITCH.getDoubleValue();
            int snapThreshOffset = (int)((double)height * threshold / indicatorRange);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)(snapThreshOffset * 2), (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)2, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)x, (int)(yCenter + snapThreshOffset), (int)width, (int)2, (int)-14614752);
            }
        } else if (!isSnapRange) {
            fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)(x + 1), (int)(yCenter - 1), (int)(width - 2), (int)2, (int)-4144960);
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((GuiContext)ctx, (int)x, (int)(lineY - 1), (int)width, (int)2, (int)-1);
    }
}

