/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.villager;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.villager.FavoriteData;
import fi.dy.masa.itemscroller.villager.IMerchantScreenHandler;
import fi.dy.masa.itemscroller.villager.TradeType;
import fi.dy.masa.itemscroller.villager.VillagerData;
import fi.dy.masa.itemscroller.villager.VillagerUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.util.DataFileUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1728;
import net.minecraft.class_1914;
import net.minecraft.class_1916;

public class VillagerDataStorage {
    private static final VillagerDataStorage INSTANCE = new VillagerDataStorage();
    private final Map<UUID, VillagerData> data = new HashMap<UUID, VillagerData>();
    private final List<TradeType> globalFavorites = new ArrayList<TradeType>();
    private UUID lastInteractedUUID;
    private boolean dirty;

    public static VillagerDataStorage getInstance() {
        return INSTANCE;
    }

    public void setLastInteractedUUID(UUID uuid) {
        this.lastInteractedUUID = uuid;
    }

    @Nullable
    public VillagerData getDataForLastInteractionTarget() {
        return this.getDataFor(this.lastInteractedUUID, true);
    }

    public VillagerData getDataFor(@Nullable UUID uuid, boolean create) {
        VillagerData data;
        VillagerData villagerData = data = uuid != null ? this.data.get(uuid) : null;
        if (data == null && uuid != null && create) {
            this.setLastInteractedUUID(uuid);
            data = new VillagerData(uuid);
            this.data.put(uuid, data);
            this.dirty = true;
        }
        return data;
    }

    public void setTradeListPosition(int position) {
        VillagerData data = this.getDataFor(this.lastInteractedUUID, true);
        if (data != null) {
            data.setTradeListPosition(position);
            this.dirty = true;
        }
    }

    public void toggleFavorite(int tradeIndex) {
        VillagerData data = this.getDataFor(this.lastInteractedUUID, true);
        if (data != null) {
            data.toggleFavorite(tradeIndex);
            this.dirty = true;
        }
    }

    public void toggleGlobalFavorite(class_1914 trade) {
        TradeType type = TradeType.of(trade);
        if (this.globalFavorites.contains(type)) {
            this.globalFavorites.remove(type);
        } else {
            this.globalFavorites.add(type);
        }
        this.dirty = true;
    }

    public FavoriteData getFavoritesForCurrentVillager(class_1728 handler) {
        return this.getFavoritesForCurrentVillager(((IMerchantScreenHandler)handler).itemscroller$getOriginalList());
    }

    public FavoriteData getFavoritesForCurrentVillager(class_1916 originalTrades) {
        IntArrayList favorites;
        VillagerData data = this.getDataFor(this.lastInteractedUUID, false);
        IntArrayList intArrayList = favorites = data != null ? data.getFavorites() : null;
        if (favorites != null && !favorites.isEmpty()) {
            return new FavoriteData(favorites, false);
        }
        if (Configs.Generic.VILLAGER_TRADE_USE_GLOBAL_FAVORITES.getBooleanValue() && this.lastInteractedUUID != null) {
            return new FavoriteData(VillagerUtils.getGlobalFavoritesFor(originalTrades, this.globalFavorites), true);
        }
        return new FavoriteData(IntArrayList.of(), favorites == null);
    }

    private void readFromNBT(CompoundData tags) {
        CompoundData tag;
        int i;
        if (tags == null || !tags.contains("VillagerData", 9)) {
            return;
        }
        ListData tagList = tags.getList("VillagerData");
        int count = tagList.size();
        for (i = 0; i < count; ++i) {
            tag = tagList.getCompoundAt(i);
            VillagerData data = VillagerData.fromNBT(tag);
            if (data == null) continue;
            this.data.put(data.getUUID(), data);
        }
        tagList = tags.getList("GlobalFavorites");
        count = tagList.size();
        for (i = 0; i < count; ++i) {
            tag = tagList.getCompoundAt(i);
            TradeType type = TradeType.fromTag(tag);
            if (type == null) continue;
            this.globalFavorites.add(type);
        }
    }

    private CompoundData writeToNBT() {
        CompoundData tags = new CompoundData();
        ListData favoriteListData = new ListData();
        ListData globalFavoriteData = new ListData();
        for (VillagerData data : this.data.values()) {
            favoriteListData.add((BaseData)data.toNBT());
        }
        for (TradeType type : this.globalFavorites) {
            globalFavoriteData.add((BaseData)type.toTag());
        }
        tags.put("VillagerData", (BaseData)favoriteListData);
        tags.put("GlobalFavorites", (BaseData)globalFavoriteData);
        this.dirty = false;
        return tags;
    }

    private String getFileName() {
        String worldName = StringUtils.getWorldOrServerName();
        if (worldName != null) {
            return "villager_data_" + worldName + ".nbt";
        }
        return "villager_data.nbt";
    }

    private Path getSaveDirPath() {
        return FileUtils.getMinecraftDirectoryAsPath().resolve("itemscroller");
    }

    public void readFromDisk() {
        this.data.clear();
        this.globalFavorites.clear();
        try {
            Path saveDir = this.getSaveDirPath();
            if (Files.isDirectory(saveDir, new LinkOption[0])) {
                Path file = saveDir.resolve(this.getFileName());
                if (Files.exists(file, new LinkOption[0])) {
                    CompoundData data = DataFileUtils.readCompoundDataFromNbtFile((Path)file);
                    if (data != null && !data.isEmpty()) {
                        this.readFromNBT(data);
                    } else {
                        ItemScroller.LOGGER.warn("readFromDisk(): Error reading villager data from file '{}'", (Object)file.toAbsolutePath());
                    }
                }
            } else {
                ItemScroller.LOGGER.warn("readFromDisk(): Error reading villager data from dir '{}'", (Object)saveDir.toAbsolutePath());
            }
        }
        catch (Exception e) {
            ItemScroller.LOGGER.warn("Failed to read villager data from file", (Throwable)e);
        }
    }

    public void writeToDisk() {
        if (this.dirty) {
            try {
                Path saveDir = this.getSaveDirPath();
                if (!Files.exists(saveDir, new LinkOption[0])) {
                    FileUtils.createDirectoriesIfMissing((Path)saveDir);
                }
                if (Files.isDirectory(saveDir, new LinkOption[0])) {
                    Path fileTmp = saveDir.resolve(this.getFileName() + ".tmp");
                    Path fileReal = saveDir.resolve(this.getFileName());
                    CompoundData data = this.writeToNBT();
                    DataFileUtils.writeCompoundDataToCompressedNbtFile((Path)fileTmp, (BaseData)data);
                    if (Files.exists(fileReal, new LinkOption[0])) {
                        Files.delete(fileReal);
                    }
                    Files.move(fileTmp, fileReal, new CopyOption[0]);
                    this.dirty = false;
                }
            }
            catch (Exception e) {
                ItemScroller.LOGGER.warn("Failed to write villager data to file!", (Throwable)e);
            }
        }
    }
}

