/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.event.KeybindCallbacks;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.itemscroller.util.MoveAmount;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.util.GuiUtils;
import javax.annotation.Nullable;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_465;

public class InputUtils {
    public static boolean isRecipeViewOpen() {
        return GuiUtils.getCurrentScreen() != null && KeybindCallbacks.getInstance().functionalityEnabled() && Hotkeys.RECIPE_VIEW.getKeybind().isKeybindHeld() && CraftingHandler.isCraftingGui(GuiUtils.getCurrentScreen());
    }

    public static boolean canShiftDropItems(class_465<?> gui, class_310 mc, int mouseX, int mouseY) {
        if (!InventoryUtils.isStackEmpty(gui.method_17577().method_34255())) {
            int left = AccessorUtils.getGuiLeft(gui);
            int top = AccessorUtils.getGuiTop(gui);
            int xSize = AccessorUtils.getGuiXSize(gui);
            int ySize = AccessorUtils.getGuiYSize(gui);
            boolean isOutsideGui = mouseX < left || mouseY < top || mouseX >= left + xSize || mouseY >= top + ySize;
            return isOutsideGui && AccessorUtils.getSlotAtPosition(gui, mouseX - left, mouseY - top) == null;
        }
        return false;
    }

    public static MoveAction getDragMoveAction(IKeybind key) {
        if (key == Hotkeys.KEY_DRAG_FULL_STACKS.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_STACKS;
        }
        if (key == Hotkeys.KEY_DRAG_LEAVE_ONE.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_DRAG_MOVE_ONE.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_MOVE_ONE;
        }
        if (key == Hotkeys.KEY_DRAG_MATCHING.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_MATCHING;
        }
        if (key == Hotkeys.KEY_DRAG_DROP_STACKS.getKeybind()) {
            return MoveAction.DROP_STACKS;
        }
        if (key == Hotkeys.KEY_DRAG_DROP_LEAVE_ONE.getKeybind()) {
            return MoveAction.DROP_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_DRAG_DROP_SINGLE.getKeybind()) {
            return MoveAction.DROP_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_STACKS.getKeybind()) {
            return MoveAction.MOVE_UP_STACKS;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_MATCHING.getKeybind()) {
            return MoveAction.MOVE_UP_MATCHING;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_LEAVE_ONE.getKeybind()) {
            return MoveAction.MOVE_UP_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_SINGLE.getKeybind()) {
            return MoveAction.MOVE_UP_MOVE_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_STACKS.getKeybind()) {
            return MoveAction.MOVE_DOWN_STACKS;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_MATCHING.getKeybind()) {
            return MoveAction.MOVE_DOWN_MATCHING;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_LEAVE_ONE.getKeybind()) {
            return MoveAction.MOVE_DOWN_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_SINGLE.getKeybind()) {
            return MoveAction.MOVE_DOWN_MOVE_ONE;
        }
        return MoveAction.NONE;
    }

    public static boolean isActionKeyActive(MoveAction action) {
        switch (action) {
            case MOVE_TO_OTHER_STACKS: {
                return Hotkeys.KEY_DRAG_FULL_STACKS.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_LEAVE_ONE: {
                return Hotkeys.KEY_DRAG_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_MOVE_ONE: {
                return Hotkeys.KEY_DRAG_MOVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_MATCHING: {
                return Hotkeys.KEY_DRAG_MATCHING.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_EVERYTHING: {
                return Hotkeys.KEY_MOVE_EVERYTHING.getKeybind().isKeybindHeld();
            }
            case DROP_STACKS: {
                return Hotkeys.KEY_DRAG_DROP_STACKS.getKeybind().isKeybindHeld();
            }
            case DROP_LEAVE_ONE: {
                return Hotkeys.KEY_DRAG_DROP_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case DROP_ONE: {
                return Hotkeys.KEY_DRAG_DROP_SINGLE.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_STACKS: {
                return Hotkeys.KEY_WS_MOVE_UP_STACKS.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_MATCHING: {
                return Hotkeys.KEY_WS_MOVE_UP_MATCHING.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_LEAVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_UP_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_MOVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_UP_SINGLE.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_STACKS: {
                return Hotkeys.KEY_WS_MOVE_DOWN_STACKS.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_MATCHING: {
                return Hotkeys.KEY_WS_MOVE_DOWN_MATCHING.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_LEAVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_DOWN_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_MOVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_DOWN_SINGLE.getKeybind().isKeybindHeld();
            }
        }
        return false;
    }

    public static MoveAmount getMoveAmount(MoveAction action) {
        switch (action) {
            case MOVE_TO_OTHER_MOVE_ONE: 
            case DROP_ONE: 
            case MOVE_UP_MOVE_ONE: 
            case MOVE_DOWN_MOVE_ONE: 
            case SCROLL_TO_OTHER_MOVE_ONE: {
                return MoveAmount.MOVE_ONE;
            }
            case MOVE_TO_OTHER_LEAVE_ONE: 
            case DROP_LEAVE_ONE: 
            case MOVE_UP_LEAVE_ONE: 
            case MOVE_DOWN_LEAVE_ONE: {
                return MoveAmount.LEAVE_ONE;
            }
            case MOVE_TO_OTHER_STACKS: 
            case DROP_STACKS: 
            case MOVE_UP_STACKS: 
            case MOVE_DOWN_STACKS: 
            case SCROLL_TO_OTHER_STACKS: {
                return MoveAmount.FULL_STACKS;
            }
            case MOVE_TO_OTHER_MATCHING: 
            case MOVE_UP_MATCHING: 
            case MOVE_DOWN_MATCHING: 
            case SCROLL_TO_OTHER_MATCHING: 
            case DROP_ALL_MATCHING: {
                return MoveAmount.ALL_MATCHING;
            }
            case MOVE_TO_OTHER_EVERYTHING: 
            case SCROLL_TO_OTHER_EVERYTHING: {
                return MoveAmount.EVERYTHING;
            }
        }
        return MoveAmount.NONE;
    }

    public static boolean isAttack(int keyCode, class_310 mc) {
        return keyCode == KeybindMulti.getKeyCode((class_304)mc.field_1690.field_1886);
    }

    public static boolean isUse(int keyCode, class_310 mc) {
        return keyCode == KeybindMulti.getKeyCode((class_304)mc.field_1690.field_1904);
    }

    public static boolean isPickBlock(int keyCode, class_310 mc) {
        return keyCode == KeybindMulti.getKeyCode((class_304)mc.field_1690.field_1871);
    }

    public static boolean isAttack(@Nullable class_11909 click, @Nullable class_11908 input, class_310 mc) {
        if (click != null && mc.field_1690.field_1886.method_1433(click)) {
            return true;
        }
        return input != null && mc.field_1690.field_1886.method_1417(input);
    }

    public static boolean isUse(@Nullable class_11909 click, @Nullable class_11908 input, class_310 mc) {
        if (click != null && mc.field_1690.field_1904.method_1433(click)) {
            return true;
        }
        return input != null && mc.field_1690.field_1904.method_1417(input);
    }

    public static boolean isPickBlock(@Nullable class_11909 click, @Nullable class_11908 input, class_310 mc) {
        if (click != null && mc.field_1690.field_1871.method_1433(click)) {
            return true;
        }
        return input != null && mc.field_1690.field_1871.method_1417(input);
    }
}

