/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.core.render.world;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.EnumMap;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.render.viewport.ViewportProvider;
import net.caffeinemc.mods.sodium.client.util.FlawlessFrames;
import net.caffeinemc.mods.sodium.client.util.FogStorage;
import net.caffeinemc.mods.sodium.client.util.SodiumChunkSection;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.minecraft.class_1059;
import net.minecraft.class_11515;
import net.minecraft.class_11532;
import net.minecraft.class_11658;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3191;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import net.minecraft.class_9922;
import net.minecraft.class_9978;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class LevelRendererMixin
implements LevelRendererExtension {
    @Unique
    private static final EnumMap<class_11515, List<RenderPass.class_10884<GpuBufferSlice[]>>> STATIC_MAP = new EnumMap(class_11515.class);
    @Shadow
    @Final
    private class_4599 field_20951;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<class_3191>> field_20950;
    @Shadow
    private @Nullable class_638 field_4085;
    @Shadow
    private int field_4073;
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    private int field_4084;
    @Shadow
    private int field_4105;
    @Shadow
    private int field_4121;
    @Shadow
    @Final
    private class_9978 field_53077;
    @Shadow
    @Final
    private class_11661 field_61738;
    @Shadow
    @Final
    private class_11658 field_61737;
    @Unique
    private SodiumWorldRenderer renderer;
    @Unique
    private ChunkRenderMatrices matrices;

    @Override
    public SodiumWorldRenderer sodium$getWorldRenderer() {
        return this.renderer;
    }

    @Redirect(method={"method_3279()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_315;method_38521()I", ordinal=1))
    private int nullifyBuiltChunkStorage(class_315 options) {
        return 0;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_310;Lnet/minecraft/class_898;Lnet/minecraft/class_824;Lnet/minecraft/class_4599;Lnet/minecraft/class_11658;Lnet/minecraft/class_11684;)V"}, at={@At(value="RETURN")})
    private void init(class_310 client, class_898 entityRenderDispatcher, class_824 blockEntityRenderDispatcher, class_4599 renderBuffers, class_11658 levelRenderState, class_11684 featureRenderDispatcher, CallbackInfo ci) {
        this.renderer = new SodiumWorldRenderer(client);
    }

    @Inject(method={"method_3244(Lnet/minecraft/class_638;)V"}, at={@At(value="RETURN")})
    private void onWorldChanged(class_638 level, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setLevel(level);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public int method_3246() {
        return this.renderer.getVisibleChunkCount();
    }

    @Overwrite
    public boolean method_3281() {
        return this.renderer.isTerrainRenderComplete();
    }

    @Inject(method={"method_3292()V"}, at={@At(value="RETURN")})
    private void onTerrainUpdateScheduled(CallbackInfo ci) {
        this.renderer.scheduleTerrainUpdate();
    }

    @Overwrite
    private class_11532 method_72157(Matrix4fc matrix4fc, double x, double y, double z) {
        class_11532 chunkSectionsToRender = new class_11532(this.field_4088.method_1531().method_4619(class_1059.field_5275).method_71659(), STATIC_MAP, -1, new GpuBufferSlice[0]);
        ((SodiumChunkSection)chunkSectionsToRender).sodium$setRendering(this.renderer, this.matrices, x, y, z);
        return chunkSectionsToRender;
    }

    @Inject(method={"method_22710(Lnet/minecraft/class_9922;Lnet/minecraft/class_9779;ZLnet/minecraft/class_4184;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_761;method_74752(Lnet/minecraft/class_4184;Lnet/minecraft/class_4604;Z)V")})
    private void sodium$setMatrices(class_9922 graphicsResourceAllocator, class_9779 deltaTracker, boolean bl, class_4184 camera, Matrix4f matrix4f, Matrix4f matrix4f2, Matrix4f matrix4f3, GpuBufferSlice gpuBufferSlice, Vector4f vector4f, boolean bl2, CallbackInfo ci) {
        this.matrices = new ChunkRenderMatrices((Matrix4fc)matrix4f2, (Matrix4fc)matrix4f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void method_74752(class_4184 camera, class_4604 frustum, boolean spectator) {
        Viewport viewport = ((ViewportProvider)frustum).sodium$createViewport();
        boolean updateChunksImmediately = FlawlessFrames.isActive();
        int sectionX = class_4076.method_32204((double)camera.method_71156().method_10216());
        int sectionY = class_4076.method_32204((double)camera.method_71156().method_10214());
        int sectionZ = class_4076.method_32204((double)camera.method_71156().method_10215());
        if (this.field_4084 != sectionX || this.field_4105 != sectionY || this.field_4121 != sectionZ) {
            this.field_4084 = sectionX;
            this.field_4105 = sectionY;
            this.field_4121 = sectionZ;
            this.field_53077.method_67549();
        }
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setupTerrain(camera, viewport, ((FogStorage)this.field_4088.field_1773).sodium$getFogParameters(), spectator, updateChunksImmediately, this.matrices);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void method_18146(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Overwrite
    public void method_18145(int x, int y, int z) {
        this.renderer.scheduleRebuildForChunks(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, false);
    }

    @Overwrite
    private void method_16037(class_2338 pos, boolean important) {
        this.renderer.scheduleRebuildForBlockArea(pos.method_10263() - 1, pos.method_10264() - 1, pos.method_10260() - 1, pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, important);
    }

    @Overwrite
    private void method_3295(int x, int y, int z, boolean important) {
        this.renderer.scheduleRebuildForChunk(x, y, z, important);
    }

    @Overwrite
    public boolean method_40050(class_2338 pos) {
        return this.renderer.isSectionReady(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    @Inject(method={"method_3279()V"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Inject(method={"method_74314(Lnet/minecraft/class_4184;FLnet/minecraft/class_11658;)V"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void extractVisibleBlockEntities(class_4184 camera, float f, class_11658 levelRenderState, CallbackInfo ci) {
        ci.cancel();
        this.renderer.extractBlockEntities(camera, f, this.field_20950, levelRenderState);
    }

    @Inject(method={"iterateVisibleBlockEntities"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void replaceBlockEntityIteration(Consumer<class_2586> blockEntityConsumer, CallbackInfo ci) {
        ci.cancel();
        this.renderer.iterateVisibleBlockEntities(blockEntityConsumer);
    }

    @Overwrite
    public String method_3289() {
        return this.renderer.getChunksDebugString();
    }

    @Override
    public void sodium$setMatrices(ChunkRenderMatrices matrices) {
        this.matrices = matrices;
    }

    @Override
    public ChunkRenderMatrices sodium$getMatrices() {
        return this.matrices;
    }
}

