/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.structure.BooleanOptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ColorThemeBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.EnumOptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ExternalButtonOptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ExternalPageBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.IntegerOptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ModOptionsBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionGroupBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionPageBuilder;
import net.caffeinemc.mods.sodium.client.config.ConfigManager;
import net.caffeinemc.mods.sodium.client.config.builder.BooleanOptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.ColorThemeBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.EnumOptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.ExternalButtonOptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.ExternalPageBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.IntegerOptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.ModOptionsBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.OptionGroupBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.OptionPageBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.minecraft.class_2960;

public class ConfigBuilderImpl
implements ConfigBuilder {
    private final List<ModOptionsBuilderImpl> pendingModConfigBuilders = new ArrayList<ModOptionsBuilderImpl>(1);
    private final Function<String, ConfigManager.ModMetadata> modInfoFunction;
    private final String defaultConfigId;

    public ConfigBuilderImpl(Function<String, ConfigManager.ModMetadata> modInfoFunction, String defaultConfigId) {
        this.modInfoFunction = modInfoFunction;
        this.defaultConfigId = defaultConfigId;
    }

    public Collection<ModOptions> build() {
        ArrayList<ModOptions> configs = new ArrayList<ModOptions>(this.pendingModConfigBuilders.size());
        for (ModOptionsBuilderImpl builder : this.pendingModConfigBuilders) {
            configs.add(builder.build());
        }
        return configs;
    }

    @Override
    public ModOptionsBuilder registerModOptions(String configId, String name, String version) {
        ModOptionsBuilderImpl builder = new ModOptionsBuilderImpl(configId, name, version);
        this.pendingModConfigBuilders.add(builder);
        return builder;
    }

    @Override
    public ModOptionsBuilder registerModOptions(String configId) {
        ConfigManager.ModMetadata metadata = this.modInfoFunction.apply(configId);
        return this.registerModOptions(configId, metadata.modName(), metadata.modVersion());
    }

    @Override
    public ModOptionsBuilder registerOwnModOptions() {
        return this.registerModOptions(this.defaultConfigId);
    }

    @Override
    public ColorThemeBuilder createColorTheme() {
        return new ColorThemeBuilderImpl();
    }

    @Override
    public OptionPageBuilder createOptionPage() {
        return new OptionPageBuilderImpl();
    }

    @Override
    public ExternalPageBuilder createExternalPage() {
        return new ExternalPageBuilderImpl();
    }

    @Override
    public OptionGroupBuilder createOptionGroup() {
        return new OptionGroupBuilderImpl();
    }

    @Override
    public BooleanOptionBuilder createBooleanOption(class_2960 id) {
        return new BooleanOptionBuilderImpl(id);
    }

    @Override
    public IntegerOptionBuilder createIntegerOption(class_2960 id) {
        return new IntegerOptionBuilderImpl(id);
    }

    @Override
    public <E extends Enum<E>> EnumOptionBuilder<E> createEnumOption(class_2960 id, Class<E> enumClass) {
        return new EnumOptionBuilderImpl<E>(id, enumClass);
    }

    @Override
    public ExternalButtonOptionBuilder createExternalButtonOption(class_2960 id) {
        return new ExternalButtonOptionBuilderImpl(id);
    }
}

