/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.render.IMixinBlockRenderManager;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.ao.AOBrightness;
import fi.dy.masa.litematica.render.schematic.ao.AOLightmap;
import fi.dy.masa.litematica.render.schematic.ao.AOProcessor;
import fi.dy.masa.litematica.render.schematic.ao.AOProcessorLegacy;
import fi.dy.masa.litematica.render.schematic.ao.AOProcessorModern;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1092;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_761;
import net.minecraft.class_775;
import net.minecraft.class_776;
import net.minecraft.class_777;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3fc;

public class BlockModelRendererSchematic {
    public static final ThreadLocal<AOBrightness> BRIGHTNESS_CACHE = ThreadLocal.withInitial(AOBrightness::new);
    private final class_6575 random = new class_6575(42L);
    private final class_324 colorMap;
    private class_775 liquidRenderer;
    private class_1092 bakedManager;

    public BlockModelRendererSchematic(class_324 blockColorsIn, class_776 manager) {
        this.colorMap = blockColorsIn;
        this.reload(manager);
    }

    public static void enableCache() {
        if (Configs.Visuals.RENDER_AO_MODERN_ENABLE.getBooleanValue()) {
            BRIGHTNESS_CACHE.get().enable();
        }
    }

    public static void disableCache() {
        if (Configs.Visuals.RENDER_AO_MODERN_ENABLE.getBooleanValue()) {
            BRIGHTNESS_CACHE.get().disable();
        }
    }

    public void reload(class_776 manager) {
        this.liquidRenderer = ((IMixinBlockRenderManager)manager).litematica_getFluidRenderer();
    }

    public void setBakedManager(class_1092 manager) {
        this.bakedManager = manager;
    }

    public class_6575 getRandom() {
        return this.random;
    }

    public void setSeed(long seed) {
        this.random.method_43052(seed);
    }

    public boolean renderModel(class_1920 worldIn, List<class_10889> modelParts, class_2680 stateIn, class_2338 posIn, class_4587 matrices, class_4588 vertexConsumer, boolean cull, int overlay) {
        if (!modelParts.isEmpty()) {
            boolean ao = class_310.method_1588() && stateIn.method_26213() == 0 && modelParts.getFirst().comp_3751();
            class_243 offset = stateIn.method_26226(posIn);
            matrices.method_46416((float)offset.field_1352, (float)offset.field_1351, (float)offset.field_1350);
            try {
                if (ao) {
                    return this.renderModelSmooth(worldIn, modelParts, stateIn, posIn, matrices, vertexConsumer, overlay, cull);
                }
                return this.renderModelFlat(worldIn, modelParts, stateIn, posIn, matrices, vertexConsumer, overlay, cull);
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Tesselating block model");
                class_129 crashreportcategory = crashreport.method_562("Block model being tesselated");
                class_129.method_586((class_129)crashreportcategory, (class_5539)worldIn, (class_2338)posIn, (class_2680)stateIn);
                crashreportcategory.method_578("Using AO", (Object)ao);
                throw new class_148(crashreport);
            }
        }
        return false;
    }

    public boolean renderModelFlat(class_1920 worldIn, List<class_10889> modelParts, class_2680 stateIn, class_2338 posIn, class_4587 matrices, class_4588 vertexConsumer, int overlay, boolean cull) {
        AOLightmap lightmap = new AOLightmap();
        class_2338.class_2339 mutablePos = posIn.method_25503();
        boolean renderedSomething = false;
        int i = 0;
        int j = 0;
        for (class_10889 part : modelParts) {
            for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
                List quads;
                boolean bl2;
                int index = 1 << side.ordinal();
                boolean bl = (i & index) == 1;
                boolean bl3 = bl2 = (j & index) == 1;
                if (bl && !bl2 || (quads = part.method_68509(side)).isEmpty()) continue;
                class_2338.class_2339 pos = lightmap.pos.method_25505((class_2382)posIn, side);
                mutablePos.method_25505((class_2382)posIn, side);
                if (!bl) {
                    bl2 = BlockModelRendererSchematic.shouldRenderModelSide(worldIn, stateIn, posIn, side, cull, (class_2338)mutablePos);
                    i |= index;
                    if (bl2) {
                        j |= index;
                    }
                }
                if (!bl2) continue;
                int light = lightmap.brightnessCache.getInt(stateIn, worldIn, (class_2338)pos);
                this.renderQuadsFlat(worldIn, stateIn, posIn, matrices, vertexConsumer, quads, lightmap, overlay, light, false);
                renderedSomething = true;
            }
            List quads = part.method_68509(null);
            if (quads.isEmpty()) continue;
            this.renderQuadsFlat(worldIn, stateIn, posIn, matrices, vertexConsumer, quads, lightmap, overlay, -1, true);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    public boolean renderModelSmooth(class_1920 worldIn, List<class_10889> modelParts, class_2680 stateIn, class_2338 posIn, class_4587 matrices, class_4588 vertexConsumer, int overlay, boolean cull) {
        AOProcessor ao = AOProcessor.get();
        class_2338.class_2339 mutablePos = posIn.method_25503();
        boolean renderedSomething = false;
        int i = 0;
        int j = 0;
        for (class_10889 part : modelParts) {
            for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
                List quads;
                boolean bl2;
                int index = 1 << side.ordinal();
                boolean bl = (i & index) == 1;
                boolean bl3 = bl2 = (j & index) == 1;
                if (bl && !bl2 || (quads = part.method_68509(side)).isEmpty()) continue;
                mutablePos.method_25505((class_2382)posIn, side);
                if (!bl) {
                    bl2 = BlockModelRendererSchematic.shouldRenderModelSide(worldIn, stateIn, posIn, side, cull, (class_2338)mutablePos);
                    i |= index;
                    if (bl2) {
                        j |= index;
                    }
                }
                if (!bl2) continue;
                this.renderQuadsSmooth(worldIn, stateIn, posIn, matrices, vertexConsumer, quads, ao, overlay);
                renderedSomething = true;
            }
            List quads = part.method_68509(null);
            if (quads.isEmpty()) continue;
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrices, vertexConsumer, quads, ao, overlay);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    public static boolean shouldRenderModelSide(class_1920 worldIn, class_2680 stateIn, class_2338 posIn, class_2350 side, boolean cull, class_2338 mutable) {
        return DataManager.getRenderLayerRange().isPositionAtRenderEdgeOnSide(posIn, side) || Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() && Configs.Visuals.RENDER_TRANSLUCENT_INNER_SIDES.getBooleanValue() || class_2248.method_9607((class_2680)stateIn, (class_2680)worldIn.method_8320(mutable), (class_2350)side);
    }

    private void renderQuadsFlat(class_1920 world, class_2680 state, class_2338 pos, class_4587 matrices, class_4588 vertexConsumer, List<class_777> quads, AOLightmap lightmap, int overlay, int light, boolean useWorldLight) {
        for (class_777 bakedQuad : quads) {
            float b;
            if (useWorldLight) {
                this.getQuadDimensions(world, state, pos, bakedQuad, lightmap);
                class_2338 blockPos = lightmap.hasOffset ? lightmap.pos.method_25505((class_2382)pos, bakedQuad.comp_3723()) : pos;
                light = lightmap.brightnessCache.isEnabled() ? lightmap.brightnessCache.getInt(state, world, pos) : class_761.method_23794((class_1920)world, (class_2338)blockPos);
            }
            lightmap.fs[0] = b = world.method_24852(bakedQuad.comp_3723(), bakedQuad.comp_3725());
            lightmap.fs[1] = b;
            lightmap.fs[2] = b;
            lightmap.fs[3] = b;
            lightmap.is[0] = light;
            lightmap.is[1] = light;
            lightmap.is[2] = light;
            lightmap.is[3] = light;
            this.renderQuad(world, state, pos, vertexConsumer, matrices, bakedQuad, lightmap, overlay);
        }
    }

    private void renderQuadsSmooth(class_1920 world, class_2680 state, class_2338 pos, class_4587 matrices, class_4588 vertexConsumer, List<class_777> quads, AOProcessor ao, int overlay) {
        for (class_777 bakedQuad : quads) {
            this.getQuadDimensions(world, state, pos, bakedQuad, ao);
            ao.apply(world, state, pos, bakedQuad.comp_3723(), bakedQuad.comp_3725());
            this.renderQuad(world, state, pos, vertexConsumer, matrices, bakedQuad, ao, overlay);
        }
    }

    private void renderQuad(class_1920 world, class_2680 state, class_2338 pos, class_4588 vertexConsumer, class_4587 matrices, class_777 quad, AOLightmap lightmap, int overlay) {
        float b;
        float g;
        float r;
        int tint = quad.comp_3722();
        if (quad.method_3360()) {
            int color;
            if (lightmap.lastTintIndex == tint) {
                color = lightmap.colorOfLastTintIndex;
            } else {
                color = this.colorMap.method_1697(state, world, pos, tint);
                lightmap.lastTintIndex = tint;
                lightmap.colorOfLastTintIndex = color;
            }
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        } else {
            r = 1.0f;
            g = 1.0f;
            b = 1.0f;
        }
        float a = 1.0f;
        vertexConsumer.method_22920(matrices.method_23760(), quad, lightmap.fs, r, g, b, a, lightmap.is, overlay);
    }

    private void getQuadDimensions(class_1920 world, class_2680 state, class_2338 pos, class_777 quad, AOLightmap lightmap) {
        float minX = 32.0f;
        float minY = 32.0f;
        float minZ = 32.0f;
        float maxX = -32.0f;
        float maxY = -32.0f;
        float maxZ = -32.0f;
        for (int index = 0; index < 4; ++index) {
            Vector3fc v3fc = quad.method_76648(index);
            float x = v3fc.x();
            float y = v3fc.y();
            float z = v3fc.z();
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        if (lightmap instanceof AOProcessorModern) {
            AOProcessorModern aoModern = (AOProcessorModern)lightmap;
            aoModern.shapeCache[class_2350.field_11039.method_10146()] = minX;
            aoModern.shapeCache[class_2350.field_11034.method_10146()] = maxX;
            aoModern.shapeCache[class_2350.field_11033.method_10146()] = minY;
            aoModern.shapeCache[class_2350.field_11036.method_10146()] = maxY;
            aoModern.shapeCache[class_2350.field_11043.method_10146()] = minZ;
            aoModern.shapeCache[class_2350.field_11035.method_10146()] = maxZ;
            aoModern.shapeCache[class_2350.field_11039.method_10146() + 6] = 1.0f - minX;
            aoModern.shapeCache[class_2350.field_11034.method_10146() + 6] = 1.0f - maxX;
            aoModern.shapeCache[class_2350.field_11033.method_10146() + 6] = 1.0f - minY;
            aoModern.shapeCache[class_2350.field_11036.method_10146() + 6] = 1.0f - maxY;
            aoModern.shapeCache[class_2350.field_11043.method_10146() + 6] = 1.0f - minZ;
            aoModern.shapeCache[class_2350.field_11035.method_10146() + 6] = 1.0f - maxZ;
        } else if (lightmap instanceof AOProcessorLegacy) {
            AOProcessorLegacy aoLegacy = (AOProcessorLegacy)lightmap;
            aoLegacy.shapeCache[class_2350.field_11039.method_10146()] = minX;
            aoLegacy.shapeCache[class_2350.field_11034.method_10146()] = maxX;
            aoLegacy.shapeCache[class_2350.field_11033.method_10146()] = minY;
            aoLegacy.shapeCache[class_2350.field_11036.method_10146()] = maxY;
            aoLegacy.shapeCache[class_2350.field_11043.method_10146()] = minZ;
            aoLegacy.shapeCache[class_2350.field_11035.method_10146()] = maxZ;
            aoLegacy.shapeCache[class_2350.field_11039.method_10146() + 6] = 1.0f - minX;
            aoLegacy.shapeCache[class_2350.field_11034.method_10146() + 6] = 1.0f - maxX;
            aoLegacy.shapeCache[class_2350.field_11033.method_10146() + 6] = 1.0f - minY;
            aoLegacy.shapeCache[class_2350.field_11036.method_10146() + 6] = 1.0f - maxY;
            aoLegacy.shapeCache[class_2350.field_11043.method_10146() + 6] = 1.0f - minZ;
            aoLegacy.shapeCache[class_2350.field_11035.method_10146() + 6] = 1.0f - maxZ;
        }
        float min = 1.0E-4f;
        float max = 0.9999f;
        lightmap.hasNeighbors = switch (quad.comp_3723()) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033, class_2350.field_11036 -> {
                if (minX >= min || minZ >= min || maxX <= max || maxZ <= max) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11043, class_2350.field_11035 -> {
                if (minX >= min || minY >= min || maxX <= max || maxY <= max) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039, class_2350.field_11034 -> minY >= min || minZ >= min || maxY <= max || maxZ <= max;
        };
        lightmap.hasOffset = switch (quad.comp_3723()) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> {
                if (minY == maxY && (minY < min || state.method_26234((class_1922)world, pos))) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11036 -> {
                if (minY == maxY && (maxY > max || state.method_26234((class_1922)world, pos))) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11043 -> {
                if (minZ == maxZ && (minZ < min || state.method_26234((class_1922)world, pos))) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (minZ == maxZ && (maxZ > max || state.method_26234((class_1922)world, pos))) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> {
                if (minX == maxX && (minX < min || state.method_26234((class_1922)world, pos))) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> minX == maxX && (maxX > max || state.method_26234((class_1922)world, pos));
        };
    }

    public void renderQuadsState(class_4587.class_4665 entry, class_4588 vertexConsumer, class_2680 state, float[] rgb, int light, int overlay) {
        if (rgb.length < 3) {
            rgb = new float[]{1.0f, 1.0f, 1.0f};
        }
        this.renderQuadsModel(entry, vertexConsumer, this.bakedManager.method_4743().method_3335(state), rgb, light, overlay, state);
    }

    public void renderQuadsModel(class_4587.class_4665 entry, class_4588 vertexConsumer, class_1087 model, float[] rgb, int light, int overlay, @Nullable class_2680 fallbackState) {
        List parts = model.method_68512((class_5819)this.random);
        if (rgb.length < 3) {
            rgb = new float[]{1.0f, 1.0f, 1.0f};
        }
        if (parts.isEmpty() && fallbackState != null) {
            class_2680 state = LitematicaRenderer.getInstance().getWorldRenderer().getFallbackState(fallbackState);
            model = this.bakedManager.method_4743().method_3335(state);
            parts = model.method_68512((class_5819)this.random);
        }
        if (parts.isEmpty()) {
            return;
        }
        for (class_10889 part : parts) {
            this.renderQuadsPart(entry, vertexConsumer, part, rgb, light, overlay);
        }
    }

    public void renderQuadsPart(class_4587.class_4665 entry, class_4588 vertexConsumer, class_10889 part, float[] rgb, int light, int overlay) {
        if (rgb.length < 3) {
            rgb = new float[]{1.0f, 1.0f, 1.0f};
        }
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            this.renderQuads(entry, vertexConsumer, part.method_68509(side), rgb, light, overlay);
        }
        this.renderQuads(entry, vertexConsumer, part.method_68509(null), rgb, light, overlay);
    }

    public void renderQuads(class_4587.class_4665 entry, class_4588 vertexConsumer, List<class_777> quads, float[] rgb, int light, int overlay) {
        if (rgb.length < 3) {
            rgb = new float[]{1.0f, 1.0f, 1.0f};
        }
        for (class_777 quad : quads) {
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            float alpha = 1.0f;
            if (quad.method_3360()) {
                red = MathUtils.clamp((float)rgb[0], (float)0.0f, (float)1.0f);
                green = MathUtils.clamp((float)rgb[1], (float)0.0f, (float)1.0f);
                blue = MathUtils.clamp((float)rgb[2], (float)0.0f, (float)1.0f);
            }
            vertexConsumer.method_22919(entry, quad, red, green, blue, alpha, light, overlay);
        }
    }

    @ApiStatus.Experimental
    public void renderLiquid(class_4588 consumer, class_1920 world, class_2338 pos, class_2680 stateIn, class_3610 fluid) {
        try {
            this.liquidRenderer.method_3347(world, pos, consumer, stateIn, fluid);
        }
        catch (Throwable var9) {
            class_128 crashReport = class_128.method_560((Throwable)var9, (String)"Tesselating liquid in world");
            class_129 crashReportSection = crashReport.method_562("Block being tesselated");
            class_129.method_586((class_129)crashReportSection, (class_5539)world, (class_2338)pos, (class_2680)stateIn);
            throw new class_148(crashReport);
        }
    }

    public boolean renderBlockState(class_4587 matrices, class_4597 consumer, class_2680 stateIn, int light, int overlay) {
        class_2464 blockRenderType = stateIn.method_26217();
        if (blockRenderType == class_2464.field_11455) {
            return false;
        }
        class_1087 model = this.bakedManager.method_4743().method_3335(stateIn);
        int i = this.colorMap.method_1697(stateIn, null, null, 0);
        float red = (float)(i >> 16 & 0xFF) / 255.0f;
        float green = (float)(i >> 8 & 0xFF) / 255.0f;
        float blue = (float)(i & 0xFF) / 255.0f;
        this.renderQuadsModel(matrices.method_23760(), consumer.method_73477(class_4696.method_23683((class_2680)stateIn)), model, new float[]{red, green, blue}, light, overlay, stateIn);
        return true;
    }
}

