/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.zoom.transitions;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import net.minecraft.class_3532;

public class EasedTransitionMode {
    private final FloatUnaryOperator startTransition;
    private final FloatUnaryOperator endTransition;
    private final FloatUnaryOperator scrollTransition;
    private final int targetStartTicks;
    private final int targetEndTicks;
    private final int targetScrollTicks;
    private final boolean invertStartTransition;
    private final boolean invertEndTransition;
    private boolean active;
    private int ticks;
    private float startZoomMultiplier;
    private float startFadeMultiplier;
    private float lastZoomMultiplier;
    private float internalMultiplier;
    private float lastInternalMultiplier;
    private float internalFade;
    private float lastInternalFade;
    private boolean scrollMode;

    public EasedTransitionMode(FloatUnaryOperator startTransition, FloatUnaryOperator endTransition, FloatUnaryOperator scrollTransition, int targetStartTicks, int targetEndTicks, int targetScrollTicks, boolean invertStartTransition, boolean invertEndTransition) {
        this.startTransition = startTransition;
        this.endTransition = endTransition;
        this.scrollTransition = scrollTransition;
        this.targetStartTicks = targetStartTicks;
        this.targetEndTicks = targetEndTicks;
        this.targetScrollTicks = targetScrollTicks;
        this.invertStartTransition = invertStartTransition;
        this.invertEndTransition = invertEndTransition;
        this.active = false;
        this.ticks = 1;
        this.startZoomMultiplier = 1.0f;
        this.startFadeMultiplier = 0.0f;
        this.lastZoomMultiplier = 1.0f;
        this.internalMultiplier = 1.0f;
        this.lastInternalMultiplier = 1.0f;
        this.internalFade = 0.0f;
        this.lastInternalFade = 0.0f;
        this.scrollMode = false;
    }

    public boolean getActive() {
        return this.active || this.ticks <= this.targetEndTicks;
    }

    public float applyZoom(float fov, float tickDelta) {
        return fov * class_3532.method_16439((float)tickDelta, (float)this.lastInternalMultiplier, (float)this.internalMultiplier);
    }

    public float getFade(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastInternalFade, (float)this.internalFade);
    }

    public void tick(boolean active, double divisor) {
        boolean skipTransition;
        float zoomMultiplier = (float)(1.0 / divisor);
        float fadeMultiplier = active ? 1.0f : 0.0f;
        boolean bl = skipTransition = active && this.targetStartTicks == 0 || !active && this.targetEndTicks == 0;
        if (skipTransition) {
            this.internalMultiplier = active ? zoomMultiplier : 1.0f;
            this.internalFade = active ? fadeMultiplier : 1.0f;
            this.lastInternalMultiplier = this.internalMultiplier;
            this.lastInternalFade = this.internalFade;
        } else {
            boolean invert;
            int oppositeTargetTicks;
            int targetTicks = active ? (this.scrollMode ? this.targetScrollTicks : this.targetStartTicks) : this.targetEndTicks;
            int n = oppositeTargetTicks = active ? this.targetEndTicks : this.targetStartTicks;
            boolean bl2 = active ? !this.scrollMode && this.invertStartTransition : (invert = this.invertEndTransition);
            if (this.ticks <= targetTicks) {
                ++this.ticks;
            }
            this.lastInternalMultiplier = this.internalMultiplier;
            this.lastInternalFade = this.internalFade;
            if (this.active != active) {
                if (active && this.ticks >= oppositeTargetTicks) {
                    this.internalMultiplier = 1.0f;
                    this.internalFade = 0.0f;
                }
                this.ticks = 1;
                this.startZoomMultiplier = this.internalMultiplier;
                this.startFadeMultiplier = this.internalFade;
                this.scrollMode = false;
            }
            if (active && this.ticks != 1 && zoomMultiplier != this.lastZoomMultiplier) {
                this.scrollMode = true;
                this.ticks = this.targetScrollTicks / 2;
                this.lastZoomMultiplier = this.internalMultiplier;
            }
            if (this.scrollMode) {
                if (this.targetScrollTicks == 0) {
                    this.lastInternalMultiplier = this.internalMultiplier = active ? zoomMultiplier : 1.0f;
                }
                if (zoomMultiplier != this.lastZoomMultiplier) {
                    this.ticks = 1;
                    this.startZoomMultiplier = this.lastZoomMultiplier;
                    this.startFadeMultiplier = fadeMultiplier;
                }
            }
            float rawProgress = (float)Math.min(this.ticks, targetTicks) / (float)targetTicks;
            if (invert) {
                rawProgress = 1.0f - rawProgress;
            }
            float progress = this.ticks <= targetTicks ? (active ? (this.scrollMode ? this.scrollTransition.apply(rawProgress) : this.startTransition.apply(rawProgress)) : this.endTransition.apply(rawProgress)) : 1.0f;
            progress = Math.min(invert ? 1.0f - progress : progress, 1.2f);
            if (this.ticks <= targetTicks) {
                this.internalMultiplier = class_3532.method_16439((float)progress, (float)this.startZoomMultiplier, (float)(active ? zoomMultiplier : 1.0f));
                this.internalFade = class_3532.method_16439((float)progress, (float)this.startFadeMultiplier, (float)(active ? fadeMultiplier : 0.0f));
            }
        }
        this.active = active;
        this.lastZoomMultiplier = zoomMultiplier;
    }

    public double getInternalMultiplier() {
        return this.internalMultiplier;
    }
}

