/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.zoom.modifiers;

import page.langeweile.ok_zoomer.zoom.modifiers.MouseModifier;

public class ContainingMouseModifier
implements MouseModifier {
    private final MouseModifier[] modifiers;
    private boolean active;

    public ContainingMouseModifier(MouseModifier ... modifiers) {
        this.modifiers = modifiers;
        this.active = false;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public double applyXModifier(double cursorDeltaX, double cursorSensitivity, double mouseUpdateTimeDelta, double transitionMultiplier) {
        double returnedValue = cursorDeltaX;
        for (MouseModifier modifier : this.modifiers) {
            returnedValue = modifier.applyXModifier(returnedValue, cursorSensitivity, mouseUpdateTimeDelta, transitionMultiplier);
        }
        return returnedValue;
    }

    @Override
    public double applyYModifier(double cursorDeltaY, double cursorSensitivity, double mouseUpdateTimeDelta, double transitionMultiplier) {
        double returnedValue = cursorDeltaY;
        for (MouseModifier modifier : this.modifiers) {
            returnedValue = modifier.applyYModifier(returnedValue, cursorSensitivity, mouseUpdateTimeDelta, transitionMultiplier);
        }
        return returnedValue;
    }

    @Override
    public void tick(boolean active) {
        boolean anyActive = false;
        for (MouseModifier modifier : this.modifiers) {
            modifier.tick(active);
            if (!active) continue;
            anyActive = true;
        }
        this.active = anyActive;
    }
}

