/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.utils;

import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfigManager;
import page.langeweile.ok_zoomer.utils.ModUtils;
import page.langeweile.ok_zoomer.zoom.Zoom;

public class ZoomUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ok Zoomer");
    public static final class_6862<class_1792> ZOOM_DEPENDENCIES_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)ModUtils.id("zoom_dependencies"));
    public static final class_3414 ZOOM_IN_SOUND = class_3414.method_47908((class_2960)ModUtils.id("zoom.zoom_in"));
    public static final class_3414 ZOOM_OUT_SOUND = class_3414.method_47908((class_2960)ModUtils.id("zoom.zoom_out"));
    public static final class_3414 SCROLL_SOUND = class_3414.method_47908((class_2960)ModUtils.id("zoom.scroll"));
    public static int zoomStep = 0;
    private static Predicate<class_746> hasSpyglass = player -> player.method_68878();
    private static boolean safeSmartOcclusion = false;
    private static Float fadeModifier = null;

    public static void changeZoomDivisor(boolean increase) {
        class_310 minecraft = class_310.method_1551();
        int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollBase.value();
        int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollResolution.value();
        int upperScrollStep = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollStepLimit.value();
        int lowerScrollStep = 0;
        int lastZoomStep = zoomStep;
        zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep);
        double divisor = 1.0;
        if (zoomStep != 0) {
            divisor = Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution);
            Zoom.setZoomDivisor(divisor);
        } else {
            Zoom.setZoomDivisor(1.0);
        }
        if (lastZoomStep != zoomStep && ((Boolean)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollSounds.value()).booleanValue()) {
            minecraft.field_1724.method_5783(SCROLL_SOUND, 1.0f, 1.0f);
        }
        if (((Boolean)OkZoomerConfigManager.CONFIG.tweaks.debugScrolling.value()).booleanValue()) {
            minecraft.field_1724.method_7353((class_2561)class_2561.method_43470((String)(zoomStep + " - " + divisor)), true);
        }
    }

    public static void resetZoomDivisor(boolean userPrompted) {
        if (!userPrompted && !((Boolean)OkZoomerConfigManager.CONFIG.zoomScrolling.forgetScrollStep.value()).booleanValue()) {
            return;
        }
        int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollBase.value();
        int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollResolution.value();
        zoomStep = (Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.defaultScrollStep.value();
        Zoom.setZoomDivisor(Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution));
    }

    public static void keepZoomStepsWithinBounds() {
        zoomStep = class_3532.method_15340((int)zoomStep, (int)0, (int)((Integer)OkZoomerConfigManager.CONFIG.zoomScrolling.scrollStepLimit.value()));
    }

    public static boolean hasSpyglass(class_746 player) {
        return hasSpyglass.test(player);
    }

    public static void addSpyglassProvider(Predicate<class_746> provider) {
        hasSpyglass = hasSpyglass.or(provider);
    }

    public static void enableSafeSmartOcclusion() {
        safeSmartOcclusion = true;
    }

    public static boolean hasSmartOcclusion() {
        return (Boolean)OkZoomerConfigManager.CONFIG.appearance.smartOcclusion.value() != false && safeSmartOcclusion;
    }

    public static boolean canSeeDistantEntities() {
        return switch ((ConfigEnums.SeeDistantEntitiesModes)OkZoomerConfigManager.CONFIG.appearance.seeDistantEntities.value()) {
            default -> throw new MatchException(null, null);
            case ConfigEnums.SeeDistantEntitiesModes.SAFE -> safeSmartOcclusion;
            case ConfigEnums.SeeDistantEntitiesModes.ON -> true;
            case ConfigEnums.SeeDistantEntitiesModes.OFF -> false;
        };
    }

    public static Float getFadeModifier() {
        return fadeModifier;
    }

    public static void setFadeModifier(Float fadeModifier) {
        ZoomUtils.fadeModifier = fadeModifier;
    }
}

