/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config;

import org.quiltmc.config.api.ReflectiveConfig;
import org.quiltmc.config.api.annotations.Comment;
import org.quiltmc.config.api.annotations.FloatRange;
import org.quiltmc.config.api.annotations.IntegerRange;
import org.quiltmc.config.api.annotations.SerializedNameConvention;
import org.quiltmc.config.api.metadata.NamingSchemes;
import org.quiltmc.config.api.values.TrackedValue;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.metadata.RangeSubset;
import page.langeweile.ok_zoomer.config.metadata.WidgetSize;

@SerializedNameConvention(value=NamingSchemes.SNAKE_CASE)
public class OkZoomerConfig
extends ReflectiveConfig {
    @Comment(value={"Options affecting the transitions between zooming in and zooming out."})
    public final ZoomTransitionConfig zoomTransition = new ZoomTransitionConfig();
    @Comment(value={"Options affecting the visual aspects of zooming."})
    public final AppearanceConfig appearance = new AppearanceConfig();
    @Comment(value={"Options affecting the way zooming is controlled."})
    public final ControlsConfig controls = new ControlsConfig();
    @Comment(value={"Options affecting the Zoom Scrolling feature."})
    public final ZoomScrollingConfig zoomScrolling = new ZoomScrollingConfig();
    @Comment(value={"Technical options that don't fit elsewhere."})
    public final TweaksConfig tweaks = new TweaksConfig();

    public static final class ZoomTransitionConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"INSTANT\": The zoom will abruptly transition between its off and on states.\n\"LINEAR\": The zoom will linearly transition between its off and on states.\n\"SMOOTH\": The zoom will smoothly transition between its off and on states using the game's smooth curve.\n\"SINE\": The zoom will smoothly transition between its off and on states using a sine curve.\n\"BALANCED\": The zoom will smoothly transition between its off and on states using cubic interpolation, balancing between linearity and smoothness.\n\"SPRING\": The zoom will bouncily transition between its off and on states. Avoid using it too often!\n"})
        public final TrackedValue<ConfigEnums.ZoomTransitionModes> startTransition = this.value(ConfigEnums.ZoomTransitionModes.SMOOTH);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"INSTANT\": The zoom will abruptly transition between its on and off states.\n\"LINEAR\": The zoom will linearly transition between its on and off states.\n\"SMOOTH\": The zoom will smoothly transition between its on and off states using the game's smooth curve.\n\"SINE\": The zoom will smoothly transition between its on and off states using a sine curve.\n\"BALANCED\": The zoom will smoothly transition between its on and off states using cubic interpolation, balancing between linearity and smoothness.\n\"SPRING\": The zoom will bouncily transition between its on and off states. Avoid using it too often!\n"})
        public final TrackedValue<ConfigEnums.ZoomTransitionModes> endTransition = this.value(ConfigEnums.ZoomTransitionModes.SMOOTH);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Controls how long the end transition should last for. 20 ticks is equal to 1 second."})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        @RangeSubset(min=0, max=100)
        public final TrackedValue<Integer> startTransitionTicks = this.value(8);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Controls how long the start transition should last for. 20 ticks is equal to 1 second."})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        @RangeSubset(min=0, max=100)
        public final TrackedValue<Integer> endTransitionTicks = this.value(8);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Inverts the start transition's curve."})
        public final TrackedValue<Boolean> invertStartTransition = this.value(false);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Inverts the end transition's curve."})
        public final TrackedValue<Boolean> invertEndTransition = this.value(false);
    }

    public static final class AppearanceConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Retains the interface when zooming."})
        public final TrackedValue<Boolean> persistentInterface = this.value(false);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Hides the crosshair while zooming."})
        public final TrackedValue<Boolean> hideCrosshair = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Divides the amount of view bobbing with the zoom divisor while zooming."})
        public final TrackedValue<Boolean> reduceViewBobbing = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Zooms the hand when zooming."})
        public final TrackedValue<Boolean> zoomHands = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"OFF\": Disables the zoom overlay.\n\"VIGNETTE\": Uses a vignette as the zoom overlay. The vignette texture can be found at assets/ok_zoomer/textures/misc/zoom_overlay.png\n\"SPYGLASS\": Uses the spyglass overlay as the zoom overlay.\n"})
        public final TrackedValue<ConfigEnums.ZoomOverlays> zoomOverlay = this.value(ConfigEnums.ZoomOverlays.OFF);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Improves performance by making the game render less of the world while zoomed in. This feature depends on the Sodium mod in order to work."})
        public final TrackedValue<Boolean> smartOcclusion = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Expands the entity distance while zooming in, allowing creatures and certain blocks to be seen from afar. This may have a performance impact during zoom."})
        public final TrackedValue<ConfigEnums.SeeDistantEntitiesModes> seeDistantEntities = this.value(ConfigEnums.SeeDistantEntitiesModes.SAFE);
    }

    public static final class ControlsConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Uses the game's cinematic camera while zooming."})
        public final TrackedValue<Boolean> cinematicCamera = this.value(false);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Changes the speed of the cinematic camera."})
        @FloatRange(min=1.1754943508222875E-38, max=32.0)
        @RangeSubset(min=1, max=16)
        public final TrackedValue<Float> cinematicCameraSpeed = this.value(Float.valueOf(1.0f));
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Reduces the mouse sensitivity proportionally to how far the zoom is."})
        public final TrackedValue<Boolean> reduceSensitivity = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"HOLD\": The zoom will require the zoom key to be held.\n\"TOGGLE\": The zoom will be toggled by the zoom key.\n\"PERSISTENT\": The zoom will always be enabled, with the zoom key being used for zoom scrolling.\n"})
        public final TrackedValue<ConfigEnums.ZoomModes> zoomMode = this.value(ConfigEnums.ZoomModes.HOLD);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Adds the spyglass's sounds effects on alternating zoom."})
        public final TrackedValue<Boolean> spyglassSounds = this.value(false);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Adds zoom manipulation keys along with the zoom key. A game restart will be required in order to apply the changes."})
        public final TrackedValue<Boolean> extraKeyBinds = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"OFF\": Zooming won't require a spyglass and won't replace its zoom.\n\"REQUIRE_ITEM\": Zooming will require a spyglass in order to work. This option is configurable through the ok_zoomer:zoom_dependencies item tag.\n\"REPLACE_ZOOM\": Zooming will replace the spyglass zoom but it won't require one in order to work.\n\"BOTH\": Zooming will act as a complete replacement of the spyglass zoom, requiring one to work and replacing its zoom as well.\n"})
        public final TrackedValue<ConfigEnums.SpyglassModes> spyglassMode = this.value(ConfigEnums.SpyglassModes.OFF);
    }

    public static final class ZoomScrollingConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Allows to increase or decrease the zoom by scrolling with the mouse wheel."})
        public final TrackedValue<Boolean> zoomScrolling = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Allows for resetting the zoom with the middle mouse button."})
        public final TrackedValue<Boolean> resetZoomWithMouse = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Adds sound effects on zoom scrolling."})
        public final TrackedValue<Boolean> scrollSounds = this.value(false);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"If enabled, the current scroll step is forgotten once zooming is finished."})
        public final TrackedValue<Boolean> forgetScrollStep = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"INSTANT\": The zoom will abruptly transition between each increment.\n\"LINEAR\": The zoom will linearly transition between each increment.\n\"SMOOTH\": The zoom will smoothly transition between each increment using the game's smooth curve.\n\"SINE\": The zoom will smoothly transition between each increment using a sine curve.\n\"BALANCED\": The zoom will smoothly transition between each increment using cubic interpolation, balancing between linearity and smoothness.\n\"SPRING\": The zoom will bouncily transition between each increment. Avoid using it too often!\n"})
        public final TrackedValue<ConfigEnums.ZoomTransitionModes> transition = this.value(ConfigEnums.ZoomTransitionModes.SMOOTH);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Controls how long should the transition last for. 20 ticks is equal to 1 second."})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        @RangeSubset(min=0, max=100)
        public final TrackedValue<Integer> transitionTicks = this.value(8);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Determines the number to be used on the exponential curve. If unsure, keep this value at 2."})
        @IntegerRange(min=2L, max=0x7FFFFFFFL)
        @RangeSubset(min=2, max=10)
        public final TrackedValue<Integer> scrollBase = this.value(2);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Determines the resolution of zoom scrolling. This will effectively multiply the amount of scroll steps."})
        @IntegerRange(min=1L, max=0x7FFFFFFFL)
        @RangeSubset(min=1, max=20)
        public final TrackedValue<Integer> scrollResolution = this.value(5);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The default scroll step to use on zooming in."})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        @RangeSubset(min=0, max=100)
        public final TrackedValue<Integer> defaultScrollStep = this.value(10);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The maximum amount of scroll steps that the zoom may reach."})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        @RangeSubset(min=0, max=100)
        public final TrackedValue<Integer> scrollStepLimit = this.value(30);
    }

    public static final class TweaksConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"a"})
        public final TrackedValue<Boolean> numericSliders = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Adds a button to open Ok Zoomer settings next to the zoom key bind."})
        public final TrackedValue<Boolean> showSettingsOnKey = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Displays debug information for exponential zoom scrolling. Currently it may help with configuring the zoom scrolling."})
        public final TrackedValue<Boolean> debugScrolling = this.value(false);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Prints a random owo in the console when the game starts."})
        public final TrackedValue<Boolean> printOwoOnStart = this.value(true);
    }
}

