/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.entity.movement;

import java.util.ArrayList;
import java.util.List;
import net.caffeinemc.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ChunkAwareBlockCollisionSweeperVoxelShape
extends ChunkAwareBlockCollisionSweeper<class_265> {
    private final boolean hideLastCollision;
    private int maxHitX = Integer.MIN_VALUE;
    private int maxHitY = Integer.MIN_VALUE;
    private int maxHitZ = Integer.MIN_VALUE;
    private class_265 maxShape = null;

    public ChunkAwareBlockCollisionSweeperVoxelShape(class_1937 world, @Nullable class_1297 entity, class_238 box) {
        this(world, entity, box, false);
    }

    public ChunkAwareBlockCollisionSweeperVoxelShape(class_1937 world, @Nullable class_1297 entity, class_238 box, boolean hideLastCollision) {
        super(world, entity, box, hideLastCollision);
        this.hideLastCollision = hideLastCollision;
    }

    public class_265 getLastCollision() {
        return this.maxShape;
    }

    public class_265 computeNext() {
        while (this.cIterated < this.cTotalSize || this.nextSection()) {
            class_265 collidedShape;
            class_2680 state;
            int edgesHit;
            ++this.cIterated;
            int x = this.cX;
            int y = this.cY++;
            int z = this.cZ;
            if (this.cX < this.cEndX) {
                ++this.cX;
            } else if (this.cZ < this.cEndZ) {
                this.cX = this.cStartX;
                ++this.cZ;
            } else {
                this.cX = this.cStartX;
                this.cZ = this.cStartZ;
            }
            if ((edgesHit = this.sectionOversizedBlocks ? (x < this.minX || x > this.maxX ? 1 : 0) + (y < this.minY || y > this.maxY ? 1 : 0) + (z < this.minZ || z > this.maxZ ? 1 : 0) : 0) == 3 || !ChunkAwareBlockCollisionSweeperVoxelShape.canInteractWithBlock(state = this.cachedChunkSection.method_12254(x & 0xF, y & 0xF, z & 0xF), edgesHit)) continue;
            this.pos.method_10103(x, y, z);
            class_265 collisionShape = this.context.method_62878(state, (class_1941)this.world, (class_2338)this.pos);
            if (collisionShape == null || collisionShape == class_259.method_1073() || (collidedShape = ChunkAwareBlockCollisionSweeperVoxelShape.getCollidedShape(this.box, this.shape, collisionShape, x, y, z)) == null) continue;
            if (z >= this.maxHitZ && (z > this.maxHitZ || y >= this.maxHitY && (y > this.maxHitY || x > this.maxHitX))) {
                this.maxHitX = x;
                this.maxHitY = y;
                this.maxHitZ = z;
                class_265 previousMaxShape = this.maxShape;
                this.maxShape = collidedShape;
                if (previousMaxShape == null) continue;
                return previousMaxShape;
            }
            return collidedShape;
        }
        if (!this.hideLastCollision && this.maxShape != null) {
            class_265 previousMaxShape = this.maxShape;
            this.maxShape = null;
            return previousMaxShape;
        }
        return (class_265)this.endOfData();
    }

    public List<class_265> collectAll() {
        ArrayList<class_265> collisions = new ArrayList<class_265>();
        while (this.hasNext()) {
            collisions.add((class_265)this.next());
        }
        return collisions;
    }
}

