/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.gui.entries.BaseListCell;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseListEntry<T, C extends BaseListCell, SELF extends BaseListEntry<T, C, SELF>>
extends TooltipListEntry<List<T>>
implements Expandable {
    protected static final class_2960 CONFIG_TEX = class_2960.method_60655((String)"cloth-config2", (String)"textures/gui/cloth_config.png");
    @NotNull
    protected final List<C> cells;
    @NotNull
    protected final List<class_364> widgets;
    @NotNull
    protected final List<class_6379> narratables;
    protected boolean expanded;
    protected boolean insertButtonEnabled = true;
    protected boolean deleteButtonEnabled;
    protected boolean insertInFront;
    protected ListLabelWidget labelWidget;
    protected class_339 resetWidget;
    @NotNull
    protected Function<SELF, C> createNewInstance;
    @NotNull
    protected Supplier<List<T>> defaultValue;
    @Nullable
    protected class_2561 addTooltip = class_2561.method_43471((String)"text.cloth-config.list.add");
    @Nullable
    protected class_2561 removeTooltip = class_2561.method_43471((String)"text.cloth-config.list.remove");

    @ApiStatus.Internal
    public BaseListEntry(@NotNull class_2561 fieldName, @Nullable Supplier<Optional<class_2561[]>> tooltipSupplier, @Nullable Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, class_2561 resetButtonKey) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, false);
    }

    @ApiStatus.Internal
    public BaseListEntry(@NotNull class_2561 fieldName, @Nullable Supplier<Optional<class_2561[]>> tooltipSupplier, @Nullable Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, class_2561 resetButtonKey, boolean requiresRestart) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, requiresRestart, true, true);
    }

    @ApiStatus.Internal
    public BaseListEntry(@NotNull class_2561 fieldName, @Nullable Supplier<Optional<class_2561[]>> tooltipSupplier, @Nullable Supplier<List<T>> defaultValue, @NotNull Function<SELF, C> createNewInstance, @Nullable Consumer<List<T>> saveConsumer, class_2561 resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.deleteButtonEnabled = deleteButtonEnabled;
        this.insertInFront = insertInFront;
        this.cells = Lists.newArrayList();
        this.labelWidget = new ListLabelWidget();
        this.widgets = Lists.newArrayList((Object[])new class_364[]{this.labelWidget});
        this.narratables = Lists.newArrayList();
        this.resetWidget = class_4185.method_46430((class_2561)resetButtonKey, widget -> {
            this.widgets.removeAll(this.cells);
            this.narratables.removeAll(this.cells);
            for (BaseListCell cell : this.cells) {
                cell.onDelete();
            }
            this.cells.clear();
            ((List)defaultValue.get()).stream().map(this::getFromValue).forEach(this.cells::add);
            for (BaseListCell cell : this.cells) {
                cell.onAdd();
            }
            this.widgets.addAll(this.cells);
            this.narratables.addAll(this.cells);
        }).method_46434(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)resetButtonKey) + 6, 20).method_46431();
        this.widgets.add((class_364)this.resetWidget);
        this.narratables.add((class_6379)this.resetWidget);
        this.saveCallback = saveConsumer;
        this.createNewInstance = createNewInstance;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded && this.isEnabled();
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isEdited() {
        if (super.isEdited()) {
            return true;
        }
        return this.cells.stream().anyMatch(BaseListCell::isEdited);
    }

    public boolean isMatchDefault() {
        Optional<List<T>> defaultValueOptional = this.getDefaultValue();
        if (defaultValueOptional.isPresent()) {
            List value = (List)this.getValue();
            List<T> defaultValue = defaultValueOptional.get();
            if (value.size() != defaultValue.size()) {
                return false;
            }
            for (int i = 0; i < value.size(); ++i) {
                if (Objects.equals(value.get(i), defaultValue.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequiresRestart() {
        return this.cells.stream().anyMatch(BaseListCell::isRequiresRestart);
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    public abstract SELF self();

    public boolean isDeleteButtonEnabled() {
        return this.deleteButtonEnabled && this.isEnabled();
    }

    public boolean isInsertButtonEnabled() {
        return this.insertButtonEnabled && this.isEnabled();
    }

    public void setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
    }

    public void setInsertButtonEnabled(boolean insertButtonEnabled) {
        this.insertButtonEnabled = insertButtonEnabled;
    }

    protected abstract C getFromValue(T var1);

    @NotNull
    public Function<SELF, C> getCreateNewInstance() {
        return this.createNewInstance;
    }

    public void setCreateNewInstance(@NotNull Function<SELF, C> createNewInstance) {
        this.createNewInstance = createNewInstance;
    }

    @Nullable
    public class_2561 getAddTooltip() {
        return this.addTooltip;
    }

    public void setAddTooltip(@Nullable class_2561 addTooltip) {
        this.addTooltip = addTooltip;
    }

    @Nullable
    public class_2561 getRemoveTooltip() {
        return this.removeTooltip;
    }

    public void setRemoveTooltip(@Nullable class_2561 removeTooltip) {
        this.removeTooltip = removeTooltip;
    }

    @Override
    public Optional<List<T>> getDefaultValue() {
        if (this.defaultValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public int getItemHeight() {
        if (this.isExpanded()) {
            int i = 24;
            for (BaseListCell entry : this.cells) {
                i += entry.getCellHeight();
            }
            return i;
        }
        return 24;
    }

    public List<? extends class_364> method_25396() {
        if (!this.isExpanded()) {
            ArrayList<class_364> elements = new ArrayList<class_364>(this.widgets);
            elements.removeAll(this.cells);
            return elements;
        }
        return this.widgets;
    }

    @Override
    public List<? extends class_6379> narratables() {
        return this.narratables;
    }

    @Override
    public Optional<class_2561> getError() {
        List errors = this.cells.stream().map(BaseListCell::getConfigError).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (errors.size() > 1) {
            return Optional.of(class_2561.method_43471((String)"text.cloth-config.multi_error"));
        }
        return errors.stream().findFirst();
    }

    @Override
    public void save() {
        for (BaseListCell cell : this.cells) {
            if (!(cell instanceof ReferenceProvider)) continue;
            ((ReferenceProvider)((Object)cell)).provideReferenceEntry().save();
        }
        super.save();
    }

    @Override
    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.labelWidget.rectangle.x = x - 15;
        this.labelWidget.rectangle.y = y;
        this.labelWidget.rectangle.width = entryWidth + 15;
        this.labelWidget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    protected boolean isInsideCreateNew(double mouseX, double mouseY) {
        return this.isInsertButtonEnabled() && mouseX >= (double)(this.labelWidget.rectangle.x + 12) && mouseY >= (double)(this.labelWidget.rectangle.y + 3) && mouseX <= (double)(this.labelWidget.rectangle.x + 12 + 11) && mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isInsideDelete(double mouseX, double mouseY) {
        if (!this.isDeleteButtonEnabled()) return false;
        int n = this.labelWidget.rectangle.x;
        int n2 = this.isInsertButtonEnabled() ? 25 : 12;
        if (!(mouseX >= (double)(n + n2))) return false;
        if (!(mouseY >= (double)(this.labelWidget.rectangle.y + 3))) return false;
        int n3 = this.labelWidget.rectangle.x;
        int n4 = this.isInsertButtonEnabled() ? 25 : 12;
        if (!(mouseX <= (double)(n3 + n4 + 11))) return false;
        if (!(mouseY <= (double)(this.labelWidget.rectangle.y + 3 + 11))) return false;
        return true;
    }

    @Override
    public Optional<class_2561[]> getTooltip(int mouseX, int mouseY) {
        if (this.addTooltip != null && this.isInsideCreateNew(mouseX, mouseY)) {
            return Optional.of(new class_2561[]{this.addTooltip});
        }
        if (this.removeTooltip != null && this.isInsideDelete(mouseX, mouseY)) {
            return Optional.of(new class_2561[]{this.removeTooltip});
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        BaseListCell focused = !this.isExpanded() || this.method_25399() == null || !(this.method_25399() instanceof BaseListCell) ? null : (BaseListCell)this.method_25399();
        boolean insideLabel = this.labelWidget.rectangle.contains(mouseX, mouseY);
        boolean insideCreateNew = this.isInsideCreateNew(mouseX, mouseY);
        boolean insideDelete = this.isInsideDelete(mouseX, mouseY);
        graphics.method_25290(class_10799.field_56883, CONFIG_TEX, x - 15, y + 5, 33.0f, (float)((this.isEnabled() ? (insideLabel && !insideCreateNew && !insideDelete ? 18 : 0) : 36) + (this.isExpanded() ? 9 : 0)), 9, 9, 256, 256);
        if (this.isInsertButtonEnabled()) {
            graphics.method_25290(class_10799.field_56883, CONFIG_TEX, x - 15 + 13, y + 5, 42.0f, insideCreateNew ? 9.0f : 0.0f, 9, 9, 256, 256);
        }
        if (this.isDeleteButtonEnabled()) {
            graphics.method_25290(class_10799.field_56883, CONFIG_TEX, x - 15 + (this.isInsertButtonEnabled() ? 26 : 13), y + 5, 51.0f, focused == null ? 0.0f : (insideDelete ? 18.0f : 9.0f), 9, 9, 256, 256);
        }
        this.resetWidget.method_46421(x + entryWidth - this.resetWidget.method_25368());
        this.resetWidget.method_46419(y);
        this.resetWidget.field_22763 = this.isEditable() && this.getDefaultValue().isPresent() && !this.isMatchDefault();
        this.resetWidget.method_25394(graphics, mouseX, mouseY, delta);
        int offset = (this.isInsertButtonEnabled() || this.isDeleteButtonEnabled() ? 6 : 0) + (this.isInsertButtonEnabled() ? 9 : 0) + (this.isDeleteButtonEnabled() ? 9 : 0);
        graphics.method_35720(class_310.method_1551().field_1772, this.getDisplayedFieldName().method_30937(), x + offset, y + 6, insideLabel && !this.resetWidget.method_25405((double)mouseX, (double)mouseY) && !insideDelete && !insideCreateNew ? -1638890 : this.getPreferredTextColor());
        if (this.isExpanded()) {
            int yy = y + 24;
            for (BaseListCell cell : this.cells) {
                cell.render(graphics, -1, yy, x + 14, entryWidth - 14, cell.getCellHeight(), mouseX, mouseY, this.getParent().getFocused() != null && ((AbstractConfigEntry)this.getParent().getFocused()).equals(this) && this.method_25399() != null && this.method_25399().equals((Object)cell), delta);
                cell.updateBounds(true, x + 14, yy, entryWidth - 14, cell.getCellHeight());
                yy += cell.getCellHeight();
            }
        } else {
            int yy = y + 24;
            for (BaseListCell cell : this.cells) {
                cell.updateBounds(false, x + 14, yy, entryWidth - 14, cell.getCellHeight());
                yy += cell.getCellHeight();
            }
        }
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (BaseListCell cell : this.cells) {
            cell.updateSelected(isSelected && this.method_25399() == cell && this.isExpanded());
        }
    }

    @Override
    public int getInitialReferenceOffset() {
        return 24;
    }

    public boolean insertInFront() {
        return this.insertInFront;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        if (super.method_25405(mouseX, mouseY)) {
            return true;
        }
        if (this.isExpanded()) {
            for (BaseListCell cell : this.cells) {
                if (!cell.method_25405(mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    public class ListLabelWidget
    implements class_364 {
        protected Rectangle rectangle = new Rectangle();

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (!BaseListEntry.this.isEnabled()) {
                return false;
            }
            if (BaseListEntry.this.resetWidget.method_25405(event.comp_4798(), event.comp_4799())) {
                return false;
            }
            if (BaseListEntry.this.isInsideCreateNew(event.comp_4798(), event.comp_4799())) {
                BaseListCell cell;
                BaseListEntry.this.setExpanded(true);
                if (BaseListEntry.this.insertInFront()) {
                    cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(0, cell);
                    BaseListEntry.this.widgets.add(0, (class_364)cell);
                } else {
                    cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this.self()));
                    BaseListEntry.this.cells.add(cell);
                    BaseListEntry.this.widgets.add((class_364)cell);
                }
                cell.onAdd();
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            if (BaseListEntry.this.isDeleteButtonEnabled() && BaseListEntry.this.isInsideDelete(event.comp_4798(), event.comp_4799())) {
                class_364 focused = BaseListEntry.this.method_25399();
                if (BaseListEntry.this.isExpanded() && focused instanceof BaseListCell) {
                    ((BaseListCell)focused).onDelete();
                    BaseListEntry.this.cells.remove(focused);
                    BaseListEntry.this.widgets.remove(focused);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
                return true;
            }
            if (this.rectangle.contains(event.comp_4798(), event.comp_4799())) {
                BaseListEntry.this.setExpanded(!BaseListEntry.this.expanded);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
            return false;
        }

        public void method_25365(boolean bl) {
        }

        public boolean method_25370() {
            return false;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.rectangle.contains(mouseX, mouseY) && !BaseListEntry.this.resetWidget.method_25405(mouseX, mouseY);
        }
    }
}

